

; k7p5.asm ATtiny12 Gewinnzahlen im Lotto und Wrfel
; Port B: B5:frei B4:Taster B3:Schalter B2:SCKL B1:RC B0:SERein 
        .INCLUDE "tn12def.inc"  ; Deklarationen
        .DEF     akku = r16     ; Arbeitsregister
        .DEF     hilf = r17     ; Hilfsregister
        .DEF     zaehl = r18    ; laufender Zhler
        .DEF     null = r19     ; Nullregister
        .DEF     endwe = r20    ; variabler Endwert
        .EQU     lotto = 49     ; Lotto
        .EQU     wuerf = 6      ; Wrfel
        .CSEG                   ; Programmsegment
        rjmp    start           ; Reset-Einsprung
        .ORG    $10             ; Interrupteinsprnge bergehen
start:  ldi     akku,0b111      ; PB2 PB1 PB0 sind Ausgnge
        out     DDRB,akku       ; Richtung Port B
        clr     null            ; Nullregister lschen
haupt:  ldi     endwe,lotto+1   ; Vorgabe: Lottozahlen
        sbis    PINB,PB4        ; Kippschalter High: Lotto
        ldi     endwe,wuerf+1   ; Kippschalter Low: Wrfel
        ldi     zaehl,1         ; Anfangswert Zhler
haupt1: rcall   ausgabe         ; ausgeben       
        sbis    PINB,PB3        ; berspringe wenn Taste High
        rjmp    haupt3          ; Low: Taste gedrckt
haupt2: inc     zaehl           ; Zhler erhhen
        cp      zaehl,endwe     ; Endwert ?
        brlo    haupt1          ; <= weiter
        rjmp    haupt           ; >  Anfangswert laden
haupt3: sbis    PINB,PB3        ; berspringe wenn Taste High
        rjmp    haupt3          ; Low: Taste gedrckt warten
        rjmp    haupt2          ; High: weiter 
;               
; Unterprogramm Ausgabe R18 zweistellig dezimal seriell
ausgabe:mov     r1,r16          ; Arbeitsregister retten
        mov     r2,r17          ; anstelle von push
        mov     r3,r18          ;  
        clr     r16             ; R16 = Zehner
; Dual nach BCD umwandeln
ausgab1:cpi     r18,10          ; Dividend < 10 ?
        brlo    ausgab2         ;   ja: fertig
        subi    r18,10          ; nein: um 10 vermindern
        inc     r16             ;       Zehner + 1
        rjmp    ausgab1         ; bis Dividend < 10 dann R18 = Einer
; umcodieren nach Siebensegmentcode         
ausgab2:ldi     ZL,LOW(tab*2)   ; Z <= Anfangsadresse Tabelle
        ldi     ZH,HIGH(tab*2)  ;
        add     ZL,r16          ; Abstand Zehner dazu
        adc     ZH,null         ; + bertrag 16bit-Operation
        lpm                     ; R0 <= Segmentcode Zehner
        mov     r17,r0          ; R17 <= Segmentcode Zehner
        ldi     ZL,LOW(tab*2)   ; Z <= Anfangsadresse Tabelle
        ldi     ZH,HIGH(tab*2)  ;
        add     ZL,r18          ; Abstand Einer dazu
        adc     ZH,null         ; + bertrag 16bit-Operation
        lpm                     ; R0 <= Segmentcode Einer
; 16 Bits seriell ausgeben MSB Einer zuerst LSB Zehner zuletzt
        cpi     r17,$3F         ; Zehnerziffer Code 0
        brne    ausgab3         ; nein:
        ldi     r17,0           ;   ja: fhrende 0 unterdrckt 
ausgab3:com     r17             ; Zehnerausgabe komplementieren
        com     r0              ; Einerausgabe komplementieren
        ldi     r18,16          ; Bitzhler
        cbi     PORTB,PB1       ; RCK bernahmetakt Low
ausgab4:cbi     PORTB,PB2       ; SCKL Schiebetakt Low 
        cbi     PORTB,PB0       ; Datenbit Low
        sbrc    r0,7            ; berspringe wenn B7 = 0
        sbi     PORTB,PB0       ; Datenbit High
        lsl     r17             ; Zehner links B7 -> Carry
        rol     r0              ; Carry -> B0 Einer
        sbi     PORTB,PB2       ; SCKL steigende Flanke
        dec     r18             ; Bitzhler vermindern
        brne    ausgab4         ; bis alle Bits gesendet
        sbi     PORTB,PB1       ; RCK bernahmetakt steigende Flanke
        mov     r18,r3          ; Arbeitsregister zurck
        mov     r17,r2          ; anstelle von pop
        mov     r16,r1          ;
        ret                     ; Rcksprung
; Codetabelle dezimale Ausgabe fr direkte Katodenansteuerung komplementieren
tab:    .DB  $3F,$06,$5b,$4F,$66,$6D,$7D,$07,$7F,$6F ; Ziffern 0..9
        .EXIT         
