 

; k7p10.asm  ATmega8  Temperatursensor AMT160-30 mit Anzeige
; Port B: B7-B0: Ausgang High-Zeit
; Port C: C5-C0: Eingang PC0 = Fhler
; Port D: D7-D0: Ausgang Periodenzeit 
; Konfiguration: interner Oszillator 1 MHz externes Reset-Signal
        .INCLUDE "m8def.inc"     ; Deklarationen
        .DEF     akku = r16      ; Arbeitsregister
        .DEF     durch = r18     ; R18 = Zhler
        .EQU     fuehl = PINC    ; Fhlerport
        .EQU     pin = PC0       ; Fhleranschluss
        .CSEG                    ; Programmsegment
         rjmp   start            ;
        .ORG    $13              ; keine Interrupts
start:  ldi     akku,LOW(RAMEND) ; Stapel anlegen
        out     SPL,akku         ;
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku         ;
        ldi     akku,$ff         ;
        out     DDRB,akku        ; Port B ist Ausgang
        out     DDRD,akku        ; Port D ist Ausgang
loop:   clr     XL               ; Low-Zhler
        clr     XH               ;
        clr     YL               ; High-Zhler
        clr     YH               ;
        clr     durch            ; Durchlaufzhler
loop1:  sbis    fuehl,pin        ; berspringe bei High
        rjmp    loop1            ; warte solange Low
; High-Ausgangs-Zustand
loop2:  sbic    fuehl,pin        ; berspringe bei Low
        rjmp    loop2            ; warte solange High
loop3:  adiw    XL,1             ; 2 Takte Low-Zhler
        sbis    fuehl,pin        ; 1 Takt berspringe bei High
        rjmp    loop3            ; 2 Takte zhle solange Low
loop4:  adiw    YL,1             ; 2 Takte High-Zhler
        sbic    fuehl,pin        ; 1 Takt berspringe bei Low
        rjmp    loop4            ; 2 Takte zhle bei High
        dec     durch            ; Durchlaufzhler
        brne    loop1            ; bis 256 Messungen 
; Messungen aus Mittelwert High-Bytes auswerten
        mov     akku,YH          ; High-Zeit
        rcall   dual2bcd         ; R16 dezimal umwandeln
        out     PORTB,akku       ; nach Port B
        mov     akku,XH          ; Low-Zeit
        add     akku,YH          ; High-Zeit + Low-Zeit
        rcall   dual2bcd         ; R16 dezimal umwandeln
        out     PORTD,akku       ; Perioden-Zeit
        rjmp    loop             ;
        .INCLUDE "dual2bcd.asm"  ; R16 dual nach R17:R16 BCD dreistellig
        .EXIT                    ; Ende des Quelltextes

