

; k7p1.asm Test Tiny12 Dualzhler auf PortB mit Hilfsstapel
; Port B: Ausgabe PB4 bis PB0 Dualzhler gemessen ca. 50 Hz an PB0
        .INCLUDE    "tn12def.inc"   ; Deklarationen fr ATtiny12 einfgen
; Konfiguration:interner Oszillator ca. 1 MHz, Stift 1 ist RESET
        .DEF        akku = r16      ; Arbeitsregister
        .DEF        stack1 = r15    ; Hilfsstapel fr push/pop
        .DEF        stack2 = r14    ; Hilfsstapel fr push/pop
        .CSEG                       ; Programm-Flash
        rjmp        start           ; Reset-Einsprung
        .ORG        $6              ; Interrupteinsprnge bergehen
start:  ldi         akku,$ff        ; 
        out         DDRB,akku       ; Port B ist Ausgang
loop:   out         PORTB,akku      ; Dualzhler ausgeben
        inc         akku            ; Dualzhler erhhen
        rcall       warte           ; Unterprogramm aufrufen ber Hardwarestapel
        rjmp        loop            ; Arbeitsschleife
; Unterprogramm ohne sbiw-Befehl und mit Softwarestapel
warte:  mov         stack1,r24      ; wie push r24  Register retten
        mov         stack2,r25      ; wie push r25  nach Softwarestapel
        ldi         r24,LOW(2000)   ;
        ldi         r25,HIGH(2000)  ;
; Wartezeit 5 Takte * 2000 Durchlufe * 1 us = 10 ms bei 1 MHz
warte1: nop                         ; 1 Takt
        subi        r24,1           ; 1 Takt
        sbci        r25,0           ; 1 Takt
        brne        warte1          ; 2 Takte
        mov         r25,stack2      ; wie pop r25  Register zurckladen
        mov         r24,stack1      ; wie pop r24  vom Softwarestapel
        ret                         ; Rcksprung
        .EXIT


