


; k6p4.asm  ATmega8 Test LCD-Anzeige und 5x5-Tastatur
; Port B: LCD-Anzeige: PB1: E-Signal
; Port D: LCD-Anzeige: PD7 PD6 PD5 PD4 (4bit)   PD3: RS-Signal
        .INCLUDE "m8def.inc"    ; Deklarationen fr ATmega8
        .EQU    takt = 8000000  ; Systemtakt Quarz 8 MHz
; Symboldefinitionen fr LCD-Schnittstelle 4bit Bus an High-Port
        .EQU    lcdpen = PORTB  ; Port des E-Signals
        .EQU    lcden = PB1     ; Bit E Freigabsignal 
        .EQU    lcdprs = PORTD  ; Port des RS-Signal
        .EQU    lcdrs = PD3     ; Bit RS Registerauswahlsignal
        .EQU    lcdpdat = PORTD ; Port des 4bit-Datenbus
        .EQU    lcdbus = 'h'    ; Anschluss an High-Port PB7..PB4
; Registerdefinitionen
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    curpos = r23    ; R23 = laufende Cursorposition
        .CSEG                   ; Programm-Flash
         rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapelzeiger
        out     SPL,akku        ; anlegen
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku        ;
        ldi     akku,0b11111000 ; PD7-PD3 sind Ausgnge
        out     DDRD,akku       ; fr LCD und Tastaturspalten
        cbi     PORTB,lcden     ; PB1 Ausgang low
        sbi     DDRB,lcden      ; PB1 ist Ausgang fr LCD-/E-Signal
        rcall   lcd4ini         ; LCD initialisieren
        clr     curpos          ; Cursor links oben
        ldi     ZL,LOW(text1*2) ; String "Willkommen
        ldi     ZH,HIGH(text1*2);         >         "
        rcall   lcd4puts        ; 
; Testschleife fr Tasten
loop:   rcall   eintas          ; R16 <- Tastencode
        cpi     r16,' '         ; Steuercode < lz (Funktionscode 1..9) ?
        brlo    loop1           ;   ja: 
        rcall   lcd4put         ; nein: Ziffer 0..9 A..F ausgeben
;        rcall   lcd4cur         ; Cursorkontrolle
        rjmp    loop            ; neue Eingabe
; 9 Funktionstasten auswerten
loop1:  rcall   lcd4func        ; Funktionstasten je nach Anwendung
        rjmp    loop            ;
;
text1: .DB  "   Willkommen   >",0 ;
;
; Externe LCD- und Tastatur-Unterprogramme
       .INCLUDE "lcd4.h"         ; lcd4ini lcd4com lcd4put lcd4puts
;       .INCLUDE "lcd4cur.asm"    ; Cursorkontrolle mit curpos
;       .INCLUDE "lcd4func.asm"   ; Funktionstasten je nach Anwendung
;       .INCLUDE "warte1ms.asm"   ; warte 1 ms bei takt
       .INCLUDE "tastatur.asm"   ; enthlt Upros taste und eintas
       .EXIT                     ; Ende des Quelltextes

