

; k4p9.asm  ATmega8  Timer1 einfacher PWM-Betrieb
; Port B: Ausgang PB1 OC1A Signalausgabe PWM
; Port C: Eingabe PC1=Bit_9 PC0=Bit_8
; Port D: Eingabe                     PD7=Bit_7   PD0=Bit_0
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        sbi     DDRB,PB1        ; PB1 ist Ausgang OC1A
        ldi     akku,$C2        ; kalibrieren
        out     OSCCAL,akku     ; RC Oszillator
; Timer1 PWM programmieren 10bit nicht invertiert 
        ldi     akku,(1 << COM1A1) | (1 << WGM11) | (1 << WGM10); 10bit 
        out     TCCR1A,akku     ; Steuerregister A Timer1
        ldi     akku,0b001      ; Taktteiler :1
        out     TCCR1B,akku     ; Steuerregister B Timer1 start
; Arbeitsschleife 
loop:   in      akku,PINC       ; Port C Compare-High
        out     OCR1AH,akku     ; PC1=Bit_9 PC0=Bit_8
        in      akku,PIND       ; Port D Compare-Low
        out     OCR1AL,akku     ; PD7=Bit_7   PD0=Bit_0
        rjmp loop               ;
       .EXIT                    ; Ende des Quelltextes


