

; k2p19.asm ATmega8 Unterprogramm mit lokalem SRAM und Unter-Unterprogramm
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
; Arbeitsschleife im Hauptprogramm                                     *
loop:   rcall   lokal           ; Unterprogramm gibt lokalen SRAM aus  *
        rjmp    loop            ;                                      *
;                                                                      *
; Unterprogramm mit lokalem SRAM                                       *
lokal:  push    r16             ; Register retten                      *
        in      r16,SREG        ; R16 <- Status mit I-Bit retten       *
        cli                     ; alle Interrupts gesperrt             *
        push    r17             ;                                      *
        push    XL              ; X rettet Stapelzeiger                *
        push    XH              ;                                      *
        push    ZL              ; Z adressiert lokalen SRAM            *
        push    ZH              ;                                      *
        in      XL,SPL          ; X <- SP retten                       *
        in      XH,SPH          ;                                      *
        mov     ZL,XL           ; Z <- Zeiger auf lokalen SRAM         *
        mov     ZH,XH           ;                                      *
        sbiw    ZL,9            ; Stapel um 9 lokale Bytes verlegen    *
        out     SPL,ZL          ; Stapel verlegt                       *
        out     SPH,ZH          ; hinter lokalen SRAM                  *
        out     SREG,r16        ; altes I-Bit wiederhergestellt        *
        adiw    ZL,1            ; Z <- Zeiger auf Anfang SRAM          *
        push    ZL              ; Zeiger retten                        *
        push    ZH              ;                                      *
        ldi     r17,9           ; R17 <- Abwrtszhler                 *
        ldi     r16,1           ; R16 <- Werte 1..9                    *
; Speicherschleife: Zahlen von 1 bis 9 speichern                       *
lokal1: st      Z+,r16          ; Wert speichern                       *
        inc     r16             ; Wert erhhen                         *
        dec     r17             ; Zhler vermindern                    *
        brne    lokal1          ; bis Liste aufgebaut                  *
        pop     ZH              ; Zeiger zurck                        *
        pop     ZL              ;                                      *
        ldi     r17,9           ; Zhler fr Listenelemente            *
; Ausgabeschleife der gespeicherten Zahlen von 1 bis 9                 *
lokal2: ld      r16,Z+          ; R16 <- Listenelement                 *
        out     PORTB,r16       ; nach Port B                          *
        rcall   warte           ; internes Unter-Unterprogramm wartet  *
        dec     r17             ;                                      *
        brne    lokal2          ;                                      *
; Stapel wiederherstellen und Rcksprung                               *
        in      r16,SREG        ; R16 <- alter Status I-Bit            *
        cli                     ; Interrupts gesperrt                  *
        out     SPL,XL          ; Stapelzeiger laden                   *
        out     SPH,XH          ;                                      *
        out     SREG,r16        ; altes I-Bit wiederhergestellt        *
        pop     ZH              ; Register zurck                      *
        pop     ZL              ;                                      *
        pop     XH              ;                                      *
        pop     XL              ;                                      *
        pop     r17             ;                                      *
        pop     r16             ;                                      *
        ret                     ; Rcksprung aus Unterprogramm lokal   *
;                                                                      *
; internes Unter-Unterprogramm 262 ms bei 1 MHz Systemtakt             *
warte:  push    XL              ; Register retten                      *
        push    XH              ;                                      *
        clr     XL              ;                                      *
        clr     XH              ;                                      *
warte1: sbiw    XL,1            ; 2 Takte                              *
        brne    warte1          ; 2 Takte                              *
        pop     XH              ; Register zurck                      *
        pop     XL              ;                                      *
        ret                     ; Rcksprung aus Unter-Unterprogramm   *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


