
/*
// c:\cprog\test\test.c  ATmega16   nur fr Testprogramme 
// Port B: Ausgabe verzgerter Dualzhler auf Leuchtdioden
// Port D: -
#include <avr/io.h>        // Deklarationen
#define TAKT 1000000UL     // Symbol Controllertakt
#include "ms1.c"
#include "nms1.c"
void test1(char x)   // Funktion gibt Argument+1 aus
{ PORTB = x+1; }
void test2(char x)   // Funktion gibt Argument+2 aus
{ PORTB = x+2; }
void test(void (*func) (char), char wert) // Funktion als Argument
{
 func(wert);                                // Argument aufgerufen
}
void main(void)
{
 DDRB = 0xff;
 while (1)
 {
  test(test1, 1);   // Funktion test1 gibt 1+1 aus 
  test(test2, 1);   // Funktion test2 gibt 1+2 aus
 }      
} // Ende main */
// c:\cprog\k3p20\k3p20.c Bild 3-26 ATmega16 Test der stdio-Funktionen 
// Minimalversion nur fr Zeichen, Strings und ganze Zahlen getestet
#include <avr/io.h>        // Deklarationen
#include <stdio.h>         // Standard Ein/Ausgabe-Funktionen
#define TAKT 1000000UL     // Controllertakt 1 MHz
#define BAUD 9600UL        // Baudrate 9600 Bd
void inituart(void)      // USART bzw. UART initialisieren
{
 unsigned char x;        // Hilfsvariable
 #ifdef UBRRL              // USART-Schnittstelle 
  UBRRL = (TAKT / (8 * BAUD)) - 1;
  UCSRA |= (1 << U2X);
  UCSRB |= (1 << TXEN) | (1 << RXEN);
  UCSRC |= (1 << URSEL) | (1 << UCSZ1) | (1 << UCSZ0); 
 #else                    // UART-Schnittstelle
  UBRR = (TAKT / (16 * BAUD)) - 1;
  UCR |= (1 << TXEN) | (1 << RXEN);
 #endif 
 x = UDR;                // Empfnger leeren
}
int putch (char x)  // warten und Zeichen senden
{
 #ifdef UCSRA
  loop_until_bit_is_set(UCSRA, UDRE); // warte bis Sender frei
 #else
  loop_until_bit_is_set(USR, UDRE);   // warte bis Sender frei
 #endif
 UDR = x;                             // Zeichen nach Sender    
 return 0;
}
int getch(void)   // warten und Zeichen abholen
{
 #ifdef UCSRA
 loop_until_bit_is_set(UCSRA, RXC);    // warte bis Zeichen da
#else 
 loop_until_bit_is_set(USR, RXC);      // warte bis Zeichen da
 #endif
 return UDR;                           // Zeichen abholen
}
int getche(void)  // warten und Zeichen mit Echo abholen
{
 char x;
 x = getch();                          // Zeichen abholen
 putch(x);                             // im Echo zurcksenden
 return x;                             // Zeichen zurckliefern
}
main(void)       // Hauptfunktion
{
 int marke;
 int x, y, z;                  // Zahlenvariable unde Fehlermarke 
 unsigned int ux, uy, uz;
 long int lx, ly, lz;
 unsigned long int ulx, uly, ulz;
 inituart();                  // USART-Schnittstelle initialisieren
 fdevopen(putch, getche, 0);  // Zeichenfunktionen fr stdout und stdin  
 while(1)                    // Testschleife fr ganze Zahlen
 {
  printf("\n\r12 Zahlen ->");                     // Meldung
  marke = scanf("%i %i %i %u %u %u %li %li %li %lu %lu %lu", &x, &y, &z, &ux, &uy, &uz, &lx, &ly, &lz, &ulx, &uly, &ulz );  
  if (marke == 12) 
  printf("%i %i %i %u %x %X %li %li %li %lu %lx %lX", x, y,z, ux, uy, uz, lx, ly, lz, ulx, uly, ulz );  
   else { clearerr(stdin); getchar(); puts(" Eingabefehler"); }  // Fehler
 printf("\n\r X=%i  Y=%i  Z=%i  Summe=%i", x, y, z, x+y+z);


  
 } // Ende while
} // Ende main






