

// c:\cprog\k3p24\sudoku.c ATmega16 neuer Sudoku Knacker MAI 2006
// STK500  Programmers Notepad 2  GNU-Compiler avr-gcc 3.4.1
#include <avr/io.h>        // Deklarationen
#define TAKT 1000000UL     // Controllertakt 1 MHz
#define BAUD 9600ul        // Baudrate 
#define SLENG 81           // Lnge des Eingabepuffers
#define a 9                // Anzahl der Zeilen und Spalten
// globale Vereinbarungen Vorgabefeld enthlt 45 Nullen
unsigned char f[a][a] = {
                           {7,0,0,0,0,0,1,9,4} , \
						   {1,8,2,0,9,0,0,3,0} , \
						   {0,0,4,5,6,1,0,0,0} , \
						   {0,7,5,2,0,0,0,0,6} , \
						   {0,0,0,9,0,8,0,0,0} , \
						   {4,0,0,0,0,6,3,2,0} , \
						   {0,0,0,8,4,3,2,0,0} , \
						   {0,4,0,0,2,0,7,5,1} , \
						   {6,2,9,0,0,0,0,0,3} };
							
unsigned char zeile[SLENG];  // Eingabepuffer fr sgets

// Grundfunktionen zur Eingabe und Ausgabe von Zeichen und Texten
void inituart(void)       // USART bzw. UART initialisieren
{
 unsigned char x;        // Hilfsvariable
 #ifdef UBRRL              // USART-Schnittstelle 
  UBRRL = (TAKT / (8 * BAUD)) - 1;
  UCSRA |= (1 << U2X);
  UCSRB |= (1 << TXEN) | (1 << RXEN);
  UCSRC |= (1 << URSEL) | (1 << UCSZ1) | (1 << UCSZ0); 
 #else                    // UART-Schnittstelle
  UBRR = (TAKT / (16 * BAUD)) - 1;
  UCR |= (1 << TXEN) | (1 << RXEN);
 #endif 
 x = UDR;                // Empfnger leeren
}

void putch (unsigned char x)  // warten und Zeichen senden
{
 #ifdef UCSRA
  loop_until_bit_is_set(UCSRA, UDRE); // warte bis Sender frei
 #else
  loop_until_bit_is_set(USR, UDRE);   // warte bis Sender frei
 #endif
 UDR = x;                             // Zeichen nach Sender    
}

unsigned char getch(void)   // warten und Zeichen abholen
{
 #ifdef UCSRA
 loop_until_bit_is_set(UCSRA, RXC);    // warte bis Zeichen da
#else 
 loop_until_bit_is_set(USR, RXC);      // warte bis Zeichen da
 #endif
 return UDR;                           // Zeichen abholen
}

unsigned char getche(void)  // warten und Zeichen mit Echo abholen
{
 unsigned char x;
 x = getch();                          // Zeichen abholen
 putch(x);                             // im Echo zurcksenden
 return x;                             // Zeichen zurckliefern
}

// Stringfunktionen fr nullterminierte Strings
void sputs(unsigned char *zeiger)     // SRAM_String ausgeben
{
 while(*zeiger != 0) putch(*zeiger++);
}

unsigned char sgets(unsigned char *zeiger) // String lesen mit Korrektur
{
 unsigned anz = 0;                         // Zeichenzhler
 while(1)
 {
  *zeiger = getch();                     // Zeichen lesen ohne Echo
  if(*zeiger >= 0x20 && anz < SLENG)    // kein Steuerzeichen
  {
   putch(*zeiger); anz++; zeiger++;     // Echo Zhler Zeiger erhhen
  } // Ende if
  else 
  {
   if(*zeiger != '\b' || anz >= SLENG)  // Ende der Eingaben
   {
    *zeiger = 0; return anz;            // Rckgabe Anzahl der Zeichen    
   } // Ende if
   else 
   if(*zeiger == '\b' && anz != 0)     // Korrektur mit Rcktaste 
   {
    zeiger--; putch('\b'); putch(' '); putch('\b'); anz--;
   }  // Ende if
  } // Ende else 
 } // Ende while
}  // Ende Funktion

// rzeile testet Zeile ergibt Anzahl der enthaltenen Ziffer x
unsigned char rzeile(unsigned char j, unsigned char x)
{
 unsigned char i, n = 0;
 for (i = 0; i < a; i++) if (f[i][j] == x) n++; 
 return n; 
}

// rspalte testet Spalte ergibt Anzahl der enthaltenen Ziffer x
unsigned char rspalte(unsigned char i, unsigned char x)
{
 unsigned char j, n = 0;
 for (j = 0; j < a; j++) if (f[i][j] == x) n++; 
 return n; 
}

// rfeld testet Block ergibt Anzahl der enthaltenen Ziffer x
unsigned char rblock(unsigned char ix, unsigned char jx, unsigned char x)
{
 unsigned char i, j, ia, ja, n = 0; 
 ia = ix - (ix % 3); ja = jx - (jx % 3); 
 for (i = 0; i < 3; i++)
 {
  for (j = 0; j < 3; j++) if (f[i+ia][j+ja] == x) n++;
 }
 return n;
}

// Funktionen zur Eingabe und Ausgabe des Spielfeldes
unsigned char ein(void)  // liefert die Anzahl der leeren Felder
{
 unsigned char i, j, nz, n = 0, k, err = 0;
 do
 {
 n = 0;
 sputs("\n\r\ngenau 9 Ziffern 1..9 oder 0 oder lz\n\r   vvvvvvvvv");
 for (j = 0; j < a; j++)
 { 
  do
  {
   nz = 0;
   sputs("\n\r ->"); nz = sgets(zeile); 
   if (nz != a) sputs(" Fehler! !Genau! 9 Ziffern eingeben!");
  } while (nz != a); 
  for (i = 0; i < a; i++)
  {
   if (zeile[i] < '0' || zeile[i] > '9') f[i][j] = 0; 
       else f[i][j] = zeile[i] - '0'; 
   if (f[i][j] == 0) n++;
  } // Ende for i 
 } // Ende for j
 // Kontrolle des Spielfeldes auf die drei Regeln
 err = 0;  // kein Fehler
 for (j = 0; j < a; j++)     // Fr alle Zeilen
 {
  for (k = 1; k <= a; k++)    // Fr alle Zahlen
  {
   if (rzeile(j, k) > 1) err++; // Fehler !!!!!
  }  //  Ende for k
 } // Ende for j
 for (i = 0; i < a; i++)     // Fr alle Spalten
 {
  for (k = 1; k <= a; k++)    // Fr alle Zahlen
  {
   if (rspalte(i, k) > 1) err++; // Fehler !!!!!
  }  //  Ende for k
 } // Ende for i
 for (i = 0; i < a; i=i+3)      // fr alle Blcke
 {
  for (j = 0; j < a; j=j+3)
  {
   for (k = 1; k <= a; k++) if (rblock(i,j,k) > 2) err++; 
  } // Ende for j 
 } // Ende for i 
 if (err != 0) sputs("\n\rRegeln nicht eingehalten !!! \n\r");
 } while (err != 0);
 return n;             // Anzahl der leeren Feldelemente 
} // Ende Funktion ein 

void aus(void)        // Ausgabe des Spielfeldes                   
{
 unsigned char i, j;
 sputs("\n\r\nAusgabe des Spielfeldes");
 for(j = 0; j < a; j++)        // fr alle Zeilen
 {
  putch(10); putch(13);        // neue Zeile
  for (i = 0; i < a; i++)     // fr alle Spalten
  {
   putch(' ');                 // Leerzeichen 
   if (f[i][j] != 0) putch(f[i][j] + '0'); else putch ('.');
  } // Ende for i
 } // Ende for j
 sputs("\n\rWeiter mit cr ->"); getch();
} // Ende aus
// ***********************************************************************************
main(void)                 // Hauptfunktion
{
 unsigned char i, j, k, geht, nleer, gef, n=0, m[a], l, ix, jx, inx, kx, indx, indy, ixa, jxa, ixx, jxx;
 inituart();               // V.24 Schnittstelle initialisieren 
 sputs("\n\rSudoku Zahlenknacker Vorgabefeld ? v -> "); 
 if (getche() == 'v') nleer = 45; else nleer = ein();  // altes nehmen oder neues eingeben  
 aus();                           // Kontrollausgabe  
 while (1)                       //  Endlosschleife
 {        
 while(nleer != 0)              // Arbeitsschleife
 {
  n = 0;                         // Sicherheitszhler
  for (j = 0; j < a; j++)       // fr alle Zeilen
  {
   for (i = 0; i < a; i++)      // fr alle Spalten
   {
    if (f[i][j] == 0)           // nur wenn Feldelement leer
	{	
     geht = 0; gef = 0; l = 0;   // Zhler fr mgliche Besetzungen
     for (k = 1; k < a+1; k++)  // fr alle Zahlen von 1 .. 9
     { 	  
	  if (rzeile(j,k) == 0 && rspalte(i,k) == 0 && rblock(i,j,k) == 0) 
	  { geht++; gef = k; m[l++] = k; } 
	 } // Ende for k Zahlen 
	 if (geht == 1) { nleer--; f[i][j] = gef; n++; }  // nur wenn Zahl eindeutig einsetzen 
     if (geht >= 2)                                     // wenn mehr als eine Zahl mglich
     {                                                  // Zahl einzig in Zeile, Spalte, Block ?
      for( l = 0; l < geht; l++)                       // fr alle mglichen Zahlen des Elementes
      {
  
	   // Elemente der Zeile untersuchen
	   inx = 0; jx = j; kx = m[l];                     // Zeile untersuchen
	   for (ix = 0; ix < a; ix++)                      // fr alle Spaltenelemente
	   {
	    if(rzeile(jx,kx)==0 && rspalte(ix,kx)==0 && rblock(ix,jx,kx)==0 && f[ix][jx] == 0)
        { inx++; indx = ix; indy = jx; }                 // Indexposition merken  
	   } // Ende for ix = alle Zeilenelemente
	   if(inx == 1) { f[indx][indy] = kx; n++; nleer--; } // Zahl nur in diesem Zeilenelement mglich
	   
	   // Elemente der Spalte untersuchen
	   inx = 0; ix = i; kx = m[l];                     // Spalte untersuchen
	   for (jx = 0; jx < a; jx++)                      // fr alle Spaltenelemente
	   {
	    if(rzeile(jx,kx)==0 && rspalte(ix,kx)==0 && rblock(ix,jx,kx)==0 && f[ix][jx] == 0) 
		{ inx++; indx = ix; indy = jx; }                        // Inxdexposition merken  
	   } // Ende for jx = alle Spaltenelemente
	   if(inx == 1) { f[indx][indy] = kx; n++; nleer--;}     // Zahl nur in diesem Spaltenelement mglich
	   
	   // Elemente des Blocks untersuchen
	   inx = 0; ix = i; jx = j; kx = m[l];              // Block untersuchen
	   ixa = ix - (ix%3); jxa = jx - (jx %3);
	   for (jxx = 0; jxx < 3; jxx++)                     // fr alle Blocklemente
	   {
	    for (ixx = 0; ixx < 3; ixx++)
	    {
	     if(rzeile(jxx+jxa,kx)==0 && rspalte(ixx+ixa,kx)==0 && rblock(ixx+ixa,jxx+jxa,kx)==0 && f[ix][jx] == 0) 
		 { inx++; indx = ix; indy = jx; }    // Inxdexposition merken  	
		} // Ende for ixx = alle Blockelemente
	   } // Ende for jxx = alle Blockelemente  
	   if(inx == 1) { f[indx][indy] = kx; n++; nleer--;}     // Zahl nur in diesem Blockelement mglich
	     
      } // Ende for l = alle mglichen Zahlen
     } // Ende if geht >= 2  
    } // Ende if Feldelement leer
   } // Ende for i Spalten
  } // Ende for j Zeilen
  sputs("\n\rgefunden = "); putch(n/10 + 0x30); putch(n%10 + 0x30);
  sputs("  noch leer = "); putch(nleer/10 + 0x30); putch(nleer%10 + 0x30);
  aus(); // Zwischenausgabe zur Kontrolle
  if (n == 0) break;            // Abbruch verhindert Endlosschleife 
 } // Ende while nleer != 0 
 if (n == 0 && nleer != 0) sputs("\n\r\nSuch Dir ein anderes Programm!");  
       else  sputs("\n\r\n******* Sudoku geloest *********"); 
 nleer = ein(); aus();           // neue Eingabe und Kontrollausgabe           
} // Ende while 1	   
} // Ende main
