

// k4p8.c  ATmega8  Timer1  Compare Betrieb Rechteckgenerator
// Port B: Ausgang PB1 OC1A Signalausgabe 1 kHz Rechteck 1:1 
// Port C: -
// Port D: -
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>              // Deklarationen
#define TAKT 1000000UL           // Systemtakt intern ca. 1 MHz
#define freq 1000ul              // 1000 Hz Rechteckausgabe
#define lade TAKT/(2ul*freq)     // Ladewert fr Compare
void main(void)                  // Hauptfunktion
{ 
 DDRB = (1 << PB1);              // PB1 OC1A ist Ausgang
 OSCCAL = 0xC2;                  // RC Oszillator kalibrieren
 OCR1A = lade;                   // Compareregister laden
 TCCR1A = (1 << COM1A0);         // OC1A bei match umschalten
 TCCR1B = (1 << WGM12) | (1 << CS10); // Timer1 lschen Taktteiler:1
 while(1) {}                     // Schleife tut nix mehr 
} // Ende main
