

// k4p4.c  ATmega8  Timer0 variable Wartezeit zur Frequenzausgabe
// Port B: PB4 Frequenzausgabe
// Port C: -
// Port D: Eingabe Wartezeit
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>          // Deklarationen
#define TAKT 1000000UL       // Controllertakt 1 MHz
void main(void)             // Hauptfunktion
{
 DDRB = (1 << PB4);         // PB4 ist Ausgang
 TCCR0 |= 0x05;              // 101 Teiler 1 MHz : 1024 = 977 Hz 
 while(1)                   // Arbeitsschleife 
 {
  TCNT0 = - PIND;                   // Wartefaktor laden
  while(!((TIFR & (1 << TOV0)))); // warte solange kein berlauf
  TIFR |= (1 << TOV0);             // berlaufanzeige lschen
  PORTB ^= (1 << PB4);             // PB4 komplementieren
 } // Ende while
} // Ende main

