

/* k4p20.c AT90S2313 A/D-Wandler mit PWM und Analogkomparator
 Port B: PB0 und PB1: analoge Eingabe  PB3: Ausgang steigende Rampe PWM
 Port D: Ausgang Messwert dual 
 PB3(OC1)/-/R=10 kOhm/-/PB0(AIN0)-C=1uF(Folie)->Gnd Eingang PB1(AIN1) Ux=0..5 V
*/
#include <avr/io.h>
// Funktionen vor main
void adini(void)   // AD-Wandler und PWM initialisieren
{
 cbi(DDRB, DDB0);   // PB0 = AIN0 = Eingang
 cbi(PORTB, PB0);   // PB0 = AIN0 tristate
 cbi(DDRB, DDB1);   // PB1 = AIN1 = Eingang
 cbi(PORTB, PB1);   // PB1 = AIN1 tristate        
 sbi(DDRB, DDB3);   // PB3 = Ausgang fr OC1 PWM 
 OCR1 = 0;          // Start bei Zhler 0
 TCCR1A = 0x81;     // 1000 0001 PWM nicht invertiert 8bit
 TCCR1B = 0x01;     // 0000 0001 Teiler : 1 = 3.6864 MHz -> 7.23 kHz PWM
 ACSR = 0x13;       // 0001 0011 ein - - - ACI=0 ICP steig. Flanke
} // Ende adini

unsigned char adein(void) // Rckgabe gewandelter Wert
{
 unsigned char i;         // Zhler 
 /* Kondensator entladen                        */
 OCR1 = 0;             // Start bei Zhler 0
 cbi(PORTB, PB0);      // Daten   PB0 = 0 = Low
 sbi(DDRB, DDB0);      // Ausgang PB0 = AIN0 = Low
 for (i=0;i<254;i++); // Schleife fr Entladezeit
 cbi(DDRB, DDB0);      // Eingang PB0 = AIN0 = tristate
 /* aufsteigende Rampe durch PWM-Signal erzeugen */
 i = 0;                  // Zhler ergibt analogen Wert
 while( (i <= 254) && (ACSR & 0x20) == 0) // solange nicht erreicht
 {
  while( (TIFR & 0x80) == 0); // warte solange kein Timer_1 berlauf
  TIFR = 0x80;                 // Flag wieder lschen
  OCR1 = i++;                  // Pulsweite und Zhler erhhen
 } // bis Rampe den analogen Messwert erreicht
  OCR1 = 0;                    // PWM-Ausgang wieder lschen
 return (unsigned char) i;   // Messwert zurck
} // Ende adein

void main(void)           // Hauptfuntion ruft adini und adein
{
 unsigned char wert, i;   // Hilfsvariable
 DDRD = 0xff;              // Port D ist nun Ausgang
 adini();                  // AD-Wandler und PWM initialisieren
 while(1)                 // Arbeitsschleife
 {
  wert = adein();          // analogen Wert abholen
  PORTD = wert >> 1;       // und geschnitten ausgeben
  for (i=0;i<254;i++);    // Warteschleife simuliert Verarbeitung
 } // Ende while
} // Ende main
