

// k4p16.c  ATmega8  USART Test Synchronbetrieb 
// Port B: -
// Port D: PD1 = TXD -> Ausgabe  PD4 Ausgang Schiebetakt
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include <avr/io.h>                 // Deklarationen
#define TAKT 1000000UL              // Controllertakt 1 MHz
#define BAUD 9600UL                 // Baudrate
void main(void)                     // Hauptfunktion
{
 unsigned int teiler;
 teiler = TAKT / (2UL * BAUD) - 1;  // Baudrate
 UBRRL = teiler;                    // Low
 UBRRH = (teiler >> 8);             // High
 UCSRC |= (1 << URSEL) | (1 << UMSEL) | (1 << UCSZ1) | (1 << UCSZ0); 
 DDRD  |= (1 << PD4);               // Taktleitung als Ausgang
 UCSRB |= (1 <<TXEN);               // nur Sender ein
 while(1)                           // Arbeitsschleife
 {
  while( !(UCSRA & (1 << UDRE)));   // warte bis Sender frei
  UDR = 0x55;                       // Bitmuster 0101 0101 ausgeben
 } // Ende while
} // Ende main
