

// k4p10.c  ATmega8  Timer1 PWM-Betrieb Kanle A und B
// Port B: Ausgang Kanal A:OC1A (PB1)  Kanal B:OC1B (PB2)
// Port C: Eingabe High-Zeit Tastverhltnis
// Port D: Eingabe Frequenz  TOP                   
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>       // Deklarationen
#define TAKT 1000000UL    // Systemtakt intern ca. 1 MHz
void main(void)          // Hauptfunktion
{ 
 DDRB = (1 << PB1) | (1 << PB2);    // PB1 OC1A PB2 OC1B Ausgnge
 OSCCAL = 0xC2;                      // RC Oszillator kalibrieren
 TCCR1A = (1 << COM1A1) | (0 << COM1A0 )| (1 << COM1B1) | (1 << COM1B0);
 TCCR1A |=  (1 << WGM11) | (0 << WGM10);        // Mode 
 TCCR1B = 0x01 | (1 << WGM13) | (0 << WGM12);   // Mode und Taktteiler :1
 while(1)            // Arbeitsschleife Eingabe High-Zeit und Frequenz
 {
  OCR1AH = PINC;     // Port C Compare-High 
  OCR1AL = 0xff;
  OCR1BH = PINC;
  OCR1BL = 0xff;  
  ICR1H = PIND;      // Port D TOP
  ICR1L = 0xff;
 } // Ende while                  
} // Ende main

