 

; k6p6.asm  ATmega8  Ref 2.56 V intern  8bit Mittel 256 Messungen
; Port B: Ausgabe Zehner und Einer
; Port C: Analoge Eingabe +5V-3.5k- ADC0 -1kPoti-1.5k-AGND
; Port D: Ausgabe Hunderter
; Konfiguration: interner Oszillator 1 MHz externes Reset-Signal
        .INCLUDE "m8def.inc"     ; Deklarationen
        .DEF     akku = r16      ; Arbeitsregister
        .CSEG                    ; Programmsegment
         rjmp   start            ;
        .ORG    $13              ; keine Interrupts
start:  ldi     akku,LOW(RAMEND) ; Stapel anlegen
        out     SPL,akku         ;
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku         ;
        ldi     akku,$ff         ;
        out     DDRB,akku        ; Port B ist Ausgang
        ldi     akku,$0f         ; 0000 1111
        out     DDRD,akku        ; Port D3-D0 ist Ausgang
        ldi     akku,(1 << REFS1) | (1 << REFS0) | (0 << ADLAR) ; 
        out     ADMUX,akku       ; Referenz 2.56V, rechtsbndig, Kanal PC0
        ldi     akku,(1 << ADEN) | (1 << ADSC) | (1 << ADPS1) | (1 << ADPS0);
        out     ADCSRA,akku      ; Wandler ein und starten, Einzel, Teiler 8
        clr     r15              ; R15 = Summe_High
        clr     r14              ; R14 = Summe_Middle
        clr     r13              ; R13 = Summe_Low
        ldi     r18,0            ; R18 = Zhler = 256
loop:   sbic    ADCSRA,ADSC      ; berspringe wenn Wandlung beendet
        rjmp    loop             ; warte auf Ende der Wandlung
        in      akku,ADCL        ; erst Low-Byte
        add     r13,akku         ;
        in      akku,ADCH        ; dann High-Byte 
        adc     r14,akku         ; 
        clr     akku             ;
        adc     r15,akku         ; Null + bertrag
        dec     r18              ;
        brne    loop1            ;
        lsr     r15              ; auf 9 bit reduzieren
        ror     r14              ; 
        lsr     r15              ; auf 8 bit reduzieren
        ror     r14              ; 
        mov     akku,r14         ; 8bit der Summe
        rcall   dual2bcd         ; R16 dual nach R17:R16 BCD dreistellig
        out     PORTD,r17        ; Hunderter nach Port D D3-D0
        out     PORTB,akku       ; Zehner und Einer nach Port B
        clr     r13              ; R13 = Summe Low
        clr     r14              ; R14 = Summe_Middle
        clr     r15              ; R15 = Summe_Jogj
        ldi     r18,0            ; R18 = Zhler = 256
loop1:  sbi     ADCSRA,ADSC      ; Wandler neu starten
        rjmp    loop             ; Schleife
        .INCLUDE "dual2bcd.asm"  ; R16 dual nach R17:R16 BCD dreistellig
        .EXIT                    ; Ende des Quelltextes

