

; k6p12.asm  ATmega8  Schrittmotor  Steuerung 
; Port B: Ausgang Schrittposition dezimal anzeigen
; Port C: Eingang Geschwindigkeit eingeben
; Port D: PD7: PD6: Eingnge Steuerung  PD3-PD0: Ausgnge
; Konfiguration: interner Takt 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    schritt = r18   ; Schrittmuster
        .DEF    position = r19  ; Schrittposition
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,0b11110000 ;
        out     PORTD,akku      ; Port D Ausgnge Low
        ldi     akku,0b00001111 ; 
        out     DDRD,akku       ; Port D Richtung
        ldi     akku,$ff        ;
        out     DDRB,akku       ; Port B ist Ausgang
        ldi     schritt,0b00010001 ; Schrittmuster
        clr     position        ; Nullstellung
; Arbeitsschleife
loop:   sbic    PIND,PD7        ; berspringe bei PD7 gedrckt
        rjmp    loop2           ; PD6 testen
; Linkslauf
loop1:  asr     schritt         ; 8bit rotieren links
        rol     schritt         ;
        rol     schritt         ;
        out     PORTD,schritt   ; 
        in      akku,PINC       ; Wartefaktor zwischen
        rcall   wartex10ms      ; den Schritten
        inc     position        ; Position + 1
        mov     akku,position   ;
        rcall   dual2bcd        ; dezimal
        out     PORTB,akku      ; ausgeben
        sbic    PIND,PD7        ; berspringe bei gedrckt
        rjmp    loop            ; springe bei gelst
        rjmp    loop1           ; weiter drehen
loop2:  sbic    PIND,PD6        ; berspringe bei gedrckt
        rjmp    loop            ; war nicht gedrckt
; Rechtslauf
loop3:  clc                     ; 8bit rotieren rechts
        sbrc    schritt,0       ;
        sec                     ;
        ror     schritt         ;
        out     PORTD,schritt   ; 
        in      akku,PINC       ; Wartefaktor zwischen
        rcall   wartex10ms      ; den Schritten
        dec     position        ; Position - 1
        mov     akku,position   ;
        rcall   dual2bcd        ; dezimal
        out     PORTB,akku      ; ausgeben
        sbic    PIND,PD6        ; berspringe bei gedrckt
        rjmp    loop            ; springe bei gelst
        rjmp    loop3           ; weiter drehen
; Unterprogramme einfgen
        .INCLUDE "dual2bcd.asm"  ; R16 dual -> R17:R16 BCD
        .INCLUDE "wartex10ms.asm";
        .EXIT                    ; Ende des Quelltextes


