

; k4p7.asm  ATmega8  Timer1 Periodendauermessung im Capture-Betrieb
; Port B: Eingang ICP1 = PB0 Messfrequenz
; Port C: Ausgabe Zhler dual High-Byte
; Port D: Ausgabe Zhler dual Low-Byte
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    ICP1addr        ; Einsprung Timer1 Capture-Signal
        rjmp    fange           ; Timer1 Interrupt-Service
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Ausgang
        out     DDRC,akku       ; Port C Ausgang
        out     DDRD,akku       ; Port D Ausgang
        ldi     akku,$C2        ; kalibrieren
        out     OSCCAL,akku     ; RC Oszillator
; Timer1: programmieren 
        ldi     akku,0b10000001 ; Strunterdr. fallende Flanke Takteiler 1
        out     TCCR1B,akku     ; Steuerregister Timer1
        clr     akku            ; Timer1 
        out     TCNT1H,akku     ; High lschen
        out     TCNT1L,akku     ; Low lschen
        in      akku,TIMSK      ; altes Interrupt-Freigaberegister
        ori     akku,(1 << TICIE1) ; Timer1 Capture Interrupt frei
        out     TIMSK,akku      ; neues Interrupt-Freigaberegister
        sei                     ; Interrupts frei
; Arbeitsschleife 
loop:   nop                     ; tu nix
        rjmp    loop            ; 
; Timer1 Capture Interrupt durch fallende Flanken
fange:  push    r16             ; Register retten
        in      r16,SREG        ; 
        push    r16             ;
        clr     r16             ; Timer1
        out     TCNT1H,akku     ; High lschen
        out     TCNT1L,akku     ; Low lschen
        in      akku,ICR1L      ; Auffang-Wert Low
        out     PORTD,akku      ; auf Port D ausgeben
        in      akku,ICR1H      ; Auffang-Wert High
        out     PORTC,akku      ; auf Port C ausgeben
        pop     r16             ; Register zurck
        out     SREG,r16        ;
        pop     r16             ;
        reti                    ; 
       .EXIT                    ; Ende des Quelltextes


