

; k4p4.asm  ATmega8  Timer0 variable Wartezeit nachladen
; Port B: Ausgabe PB4 umschalten als Frequenzausgabe
; Port C: -
; Port D: Eingabe Wartezeit
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,(1 << PB4) ; PB4 als Ausgang
        out     DDRB,akku       ; 
        mov     r17,akku        ; R17 <- EODER-Maske fr PB4
; Timer0 programmieren
        ldi     akku,0b101      ; Systemtakt / 1024 = 977 Hz 
        out     TCCR0,akku      ; Steuerregister Timer0 
; Arbeitsschleife mit berlaufkontrolle
loop:   in      akku,PIND       ; Wartefaktor lesen
        neg     akku            ; Zweierkomplement $00 - Eingabe
        out     TCNT0,akku      ; als Zhleranfangswert
warte:  in      akku,TIFR       ; berlaufbit laden
        sbrs    akku,TOV0       ; berspringe bei TOV0 = 1 berlauf
        rjmp    warte           ; warte auf berlauf
        out     TIFR,akku       ; berlaufbit wieder lschen
        in      akku,PORTB      ; altes PB4
        eor     akku,r17        ; komplementieren
        out     PORTB,akku      ; neues PB4
        rjmp    loop            ; Schleife neue Eingabe
       .EXIT                    ; Ende des Quelltextes


