

; k4p18.asm  ATmega8  Software-Emulation SPI-Schnittstelle
; Systemtakt 1 MHz : 4 = 250 kHz Schiebetakt
; Port B: SPI Anschlsse nach 74HCT165 (Schalter) und 74HC595 (LED)
; Port D: Eingabe nach Empfnger-Slave
; Port C: Ausgabe des Sender-Slave 
; Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal 
        .INCLUDE "m8def.inc"    ; Deklarationen
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programmsegment
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupts bersprungen
start:  ldi     akku,LOW(RAMEND); Endadresse SRAM
        out     SPL,akku        ; nach Stapelzeiger
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Richtung Ausgabe
        out     DDRC,akku       ; Port C ist LED-Ausgabe
        ldi     akku,(1 << DDB5) | (1 << DDB3) | (1 << DDB2) | (1 << DDB1); 
        out     DDRB,akku       ; DDB5=SCK DDB3=MOSI DDB2=SRCK DDB1=SH/LD
        cbi     PORTB,PB1       ; Sender-Slave SH/LD = 0: laden
        sbi     PORTB,PB2       ; Empfnger-Slave bernahme RCK = 1
; Hauptprogramm Arbeitsschleife
haupt:  rcall   empf            ; akku <= Sender-Slave Schalter
        out     PORTC,akku      ; Kontrollausgabe Port C
        in      akku,PIND       ; Testwerte eingeben vom Port D
        com     akku            ; invertieren wegen Katodenansteuerung
        rcall   send            ; Ausgabe Empfnger-Slave LEDs
        rjmp    haupt           ; Schleife
; Unterprogramme SPI-Software-Emulation        
; empf: R16 <= Sender-Slave MSB zuerst
empf:   push    r17             ; Register retten
        ldi     r17,8           ; R17 = Schiebezhler
        sbi     PORTB,PB1       ; Slave SH/LD = 1: schieben QH liegt an
empf1:  cbi     PORTB,PB5       ; Takt Low
        lsl     r16             ; R16 1 bit links  B0 <= 0
        sbic    PINB,PB4        ; berspringe wenn MI = 0
        inc     r16             ; fr MI = 1: R16 B0 <= 1
        sbi     PORTB,PB5       ; steigende Taktflanke: Slave schiebt
        dec     r17             ; Zhler - 1
        brne    empf1           ; bis 8 Bits empfangen
        cbi     PORTB,PB1       ; Slave SH/LD = 0: laden 
        pop     r17             ; Register zurck
        ret                     ; Rcksprung
; send: R16 => Sender-Slave MSB zuerst    
send:   push    r17             ; Register retten
        ldi     r17,8           ; R17 = Schiebezhler
        cbi     PORTB,PB2       ; Slave RCK bernahme Low
send1:  cbi     PORTB,PB5       ; Schiebetakt Low        
        cbi     PORTB,PB3       ; Ausgabebit Low
        sbrc    r16,7           ; berspringe wenn B7 = 0
        sbi     PORTB,PB3       ; fr B7 = 1: Ausgabebit High 
        lsl     r16             ; das nchste Bit fertig machen
        sbi     PORTB,PB5       ; Slave steigende Schiebeflanke 
        dec     r17             ; Zhler - 1
        brne    send1           ; bis 8 Bits gesendet
        sbi     PORTB,PB2       ; Slave steigende Flanke RCK: bernehmen
        pop     r17             ; Register zurck
        ret                     ;        
        .EXIT                   ; Ende des Programmtextes

