

; k4p10.asm  ATmega8  Timer1 PWM-Betrieb Kanle A und B
; Port B: Ausgang Kanal A:OC1A (PB1)  Kanal B:OC1B (PB2)
; Port C: Eingabe High-Zeit Tastverhltnis
; Port D: Eingabe Frequenz  TOP         
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        sbi     DDRB,PB1        ; PB1 ist Ausgang OC1A
        sbi     DDRB,PB2        ; PB2 ist Ausgang OC1B
        ldi     akku,$C2        ; kalibrieren
        out     OSCCAL,akku     ; RC Oszillator
; Timer1 PWM programmieren 
        clr     akku            ; Steuerbits einsetzen
        ori     akku,(1 << COM1A1) | (0 << COM1A0) ; nicht  
        ori     akku,(1 << COM1B1) | (1 << COM1B0) ; inv.
        ori     akku,(1 << WGM11)  | (0 << WGM10)  ; 		
        out     TCCR1A,akku     ; Steuerregister A Timer1
        ldi     akku,0b001      ; Taktteiler :1
        ori     akku,(1 << WGM13)  | (0 << WGM12)  ; 
        out     TCCR1B,akku     ; Steuerregister B Timer1 start
; Arbeitsschleife ICR1 (PIND) > OCR1A und B (PINC)  
loop:   in      akku,PINC       ; PINC: High-Zeit  High-Byte
        ser     r17             ;                  Low-Byte
        out     OCR1AH,akku     ; Kanal A  
        out     OCR1AL,r17      ;       
        out     OCR1BH,akku     ; Kanal B
        out     OCR1BL,r17      ; 
        in      akku,PIND       ; PIND: Frequenz High-Byte
        ser     r17             ;                Low-Byte
        out     ICR1H,akku      ; TOP 
        out     ICR1L,r17       ;
        rjmp loop               ;
       .EXIT                    ; Ende des Quelltextes


