

; k2p20a.asm ATmega8 Interrupt durch Potentialnderung und Timerflanke
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    INT1addr        ; Einsprung externer Interrupt INT1
        rjmp    taste3          ; nach Serviceprogramm fr Taste PD3
        .ORG    OVF0addr        ; Einsprung Timer0 berlauf
        rjmp    taste4          ; nach Serviceprogramm fr Taste PD4 
        .ORG    $2A             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        clr     akku            ; Dualzhler lschen
        out     PORTB,akku      ; und Anfangswert ausgeben
; Interrupt INT1 initialisieren fr beide Flanken an PD3
        in      akku,MCUCR      ; altes Steuerregister
        cbr     akku,1 << ISC11 ; lsche Bit ISC11
        sbr     akku,1 << ISC10 ; setze  Bit ISC10
        out     MCUCR,akku      ; ISC1x: 0 1 INT1 beide Flanken
        in      akku,GICR       ; altes Freigaberegister
        sbr     akku,1 << INT1  ; setze Bit INT1: 
        out     GICR,akku       ; Interrupt INT1 freigegeben
; Interrupt Timer0 externe Taktflanke an PD4 vorbereiten
        ldi     akku,0b110      ; externer Takt fallende Flanke
        out     TCCR0,akku      ; Steuerregister Timer0
        in      akku,TIMSK      ; Timer-Interrupt-Masken
        ori     akku,1 << TOIE0 ; Interrupt fr Timer0 
        out     TIMSK,akku      ; freigeben
        ldi     akku,$FF        ; max. Zhler nach
        out     TCNT0,akku      ; Timer0
; beide Interrupts global freigeben
        sei                     ; alle Interrupts global frei
; Hauptprogramm schlft vor sich hin
loop:   rjmp    loop            ; tu nix
;
; Serviceprogramm bedient externen Interrupt INT1 Taste PD3
taste3: push    r16             ; Register retten
        in      r16,SREG        ; Status 
        push    r16             ; retten
        in      r16,PORTB       ; alten Zhler
        inc     r16             ; um 1 erhhen
        out     PORTB,r16       ; neuen Zhler ausgeben
        pop     r16             ; 
        out     SREG,r16        ; Status zurck
        pop     r16             ;
        reti                    ; Rcksprung aus Serviceprogramm
; Serviceprogramm bedient externen Interrupt Timer0 PD4
taste4: push    r16             ; Register retten
        in      r16,SREG        ; Status 
        push    r16             ; retten
        in      r16,PORTB       ; alten Zhler
        dec     r16             ; um 1 vermindern
        out     PORTB,r16       ; neuen Zhler ausgeben
        ldi     akku,$ff        ; max. Zhler 
        out     TCNT0,akku      ; nach Timer0
        pop     r16             ; 
        out     SREG,r16        ; Status zurck
        pop     r16             ;
        reti                    ; Rcksprung aus Serviceprogramm
        .EXIT                   ; Ende des Quelltextes

