

; k2p10.asm ATmega8 Umwandlung Hexa-ASCII-Zeichen nach binr
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
loop:   in      akku,PIND       ; Eingabe Code Hexaziffer PD0 bis PD7  *
        cpi     akku,'0'        ; < Ziffer 0 ?                         *
        brlo    fehler          ; ja: nicht im Bereich                 *
        cpi     akku,'9'+1      ; > Ziffer 9 ?                         *
        brsh    weiter          ; ja: Bereich A - F untersuchen        *
        subi    akku,'0'        ; Ziffernbereich 0 - 9 decodieren      *
        rjmp    ausgabe         ; und binr ausgeben                   *
weiter: andi    akku,0b11011111 ; Maske Bit B5 = 0: klein -> gross     *
        cpi     akku,'A'        ; < Buchstabe A ?                      *
        brlo    fehler          ; ja: nicht im Bereich                 *
        cpi     akku,'F'+1      ; > Buchstabe F ?                      *
        brsh    fehler          ; ja: nicht im Bereich                 *
        subi    akku,'A'-10     ; Buchstabenbereich A - F decodieren   *
ausgabe:out     PORTB,akku      ; binr 00000000 bis 00001111 ausgeben *
        rjmp    loop            ; neue Eingabe                         *
fehler: ldi     akku,$ff        ; Fehlercode 1111 1111                 *
        out     PORTB,akku      ; ausgeben                             *
        rjmp    loop            ; neue Eingabe                         *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


