

// k6p10.c  ATmega8  Gleichstrommotor  Steuerung mit 8bit PWM
// Port B: Ausgang PB1 OC1A PWM PB7 PB6 Eingabe Impulsgeber
// Port C: Ausgabe Ladewert Hunderter
// Port D: Ausgabe Ladewert Zehner  Einer
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>                  // Deklarationen
#define TAKT 1000000UL               // Systemtakt intern ca. 1 MHz
void main(void)                      // Hauptfunktion
{ 
 unsigned int dreh = 123;            // Drehzahl
 DDRB = (1 << PB1);                  // PB1 OC1A ist Ausgang
 DDRC = DDRD= 0xff;                  // Port C und D sind Ausgnge
 TCCR1A = (1 << COM1A1) | (0 << WGM11) | (1 << WGM10); // 8bit PWM
 TCCR1B = 0x01;                      // Timer1 Taktteiler :1
 while(1)                            // Arbeitsschleife Eingabe Drehzahl
 {
  OCR1AH = 0;                        // PWM
  OCR1AL = dreh;                     // einstellen
  PORTC = dreh / 100;                // Hunderter anzeigen
  PORTD = (((dreh % 100) / 10) << 4) | (dreh % 10); // Zehner Einer
  while ( PINB & (1 << PB7));        // warte solange High
  if ( (PINB & (1 << PB6))) dreh--;  // langsamer
  if (!(PINB & (1 << PB6))) dreh++;  // schneller
  while ( !(PINB & (1 << PB7)));     // warte solange Low 
 } // Ende while                  
} // Ende main



