

// k6p1.c  ATmega8  Duo-LED-Ansteuerung und Bandanzeige
// Port B: 8bit Bandanzeige
// Port C: PC0=ADC0 10 kOhm Poti PC1:LED grn PC2: LED rot
// Port D: Duale Ausgabe
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include <avr/io.h>    // Deklarationen
void main(void)       // Hauptfunktion
{
 unsigned int ein10; // Hilfsvariable 10bit Eingabewert 
 unsigned char aus8,i,band,bereich; // Hilfsvariable 
 DDRB = 0xff;          // Port B ist Ausgang
 DDRD = 0xff;          // Port D ist Ausgang
 DDRC = 0x06;          // 0b00000110  PC2:aus PC1:aus PC0=ADC0: ein
 ADMUX = (0 << REFS1) | (0 << REFS0) | (0 << MUX1) | (0 << MUX0);
 ADCSRA = (1 << ADEN) | (1 << ADSC) | (0 << ADFR) | (1<< ADPS1) | (1 << ADPS0);
 while(1)             // Arbeitsschleife
 {
  while( ADCSRA & (1 << ADSC)); // warte auf Ende der Wandlung
  ein10 = (unsigned int) ADCL | ((unsigned int) ADCH << 8); // Reihenfolge!
  aus8 = ein10 >> 2;    // 10bit reduziert auf 8bit
  PORTD = aus8;         // Dualwert ausgeben
  // Ansteuerung Duo-LED in den drei Farben
  if (aus8 >= 204)     {sbi(PORTC,PC1); cbi(PORTC,PC2); }  // grn
   else if (aus8 < 51) {cbi(PORTC,PC1); sbi(PORTC,PC2); }  // rot
    else               {sbi(PORTC,PC1); sbi(PORTC,PC2); }  // rot + grn = gelb
  // Dualzahl nach Bandanzeige 
  band = 0xff;           // Bandanzeige Anfangswert 11111111
  bereich = 224;         // Anfangswert fr Bereichsprfung
  for (i=1; i<= 8; i++) // Schrittzhler
  {
   if (aus8 >= bereich) break;         // Bereich fr Band erfasst
   else { band >>= 1; bereich -= 32;}  // neues Band neuer Bereich 
  }
  PORTB = band;        // Bandanzeige ausgeben
  sbi(ADCSRA,ADSC);    // Wandler neu starten
 } // Ende while
} // Ende main

