

// k3p18.c ATmega8  EEPROM-Zugriff
// Port B: Ausgabe Testwerte und Feld im Sekundentakt
// Port D: Eingabe Testwert
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>            // Deklarationen
#include <avr/eeprom.h>        // EEPROM-Funktionen
#define TAKT 1000000UL         // Controllertakt 1 MHz
#define  EEPROM  __attribute__((section(".eeprom"))) // Abkrzung
#include "wartex10ms.c"       // wartet n * 10 ms
unsigned int EEPROM x = 0x0102;  // EEPROM-Variable global
void main(void)                   // Hauptfunktion
{
 static unsigned char EEPROM y = 0x03, z = 0x04;   // EEPROM statisch
 static unsigned char EEPROM tab[] = "0123456789"; // EEPROM Block
 unsigned char feld[20];                            // Puffer im SRAM
 unsigned int i;
 DDRB = 0xff;                    // Port B ist Ausgang 
 while(1)                       // Arbeitsschleife
 {
  PORTB = eeprom_read_word(&x); wartex10ms(200); // EEPROM Wort lesen
  PORTB = eeprom_read_byte(&y); wartex10ms(200); // EEPROM Byte lesen
  PORTB = eeprom_read_byte(&z); wartex10ms(200); // EEPROM Byte lesen
  eeprom_write_byte(&z, PIND);                   // EEPROM Byte schreiben
  PORTB = eeprom_read_byte(&z); wartex10ms(200); // EEPRoM Byte rcklesen
  eeprom_read_block(feld, tab, sizeof(tab));    // EEPROM Block lesen
  i=0; while( feld[i] != 0) {PORTB = feld[i++]; wartex10ms(100);} // Ausgabe
 } // Ende while
} // Ende main
