

; test9.asm Verzgerter dreistelliger Dezimalzhler 0 bis 255
; Port B: Ausgabe  Hunderter
; Port C: Zehner und Einer
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    TAKT = 8000000  ; Systemtakt 8 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    zaehl = r17     ; R18 = Dualzhler
        .DEF    hund = r18      ; R18 = Hunderter
        .DEF    zehn = r19      ; R19 = Zehner
        .DEF    ein = r20       ; R20 = Einer
        .INCLUDE "Mdual2bcd.asm"; dual -> BCD
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapelzeiger
        out     SPL,akku        ; anlegen
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku        ;
        ser     akku            ; akku <- $ff
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
; Verzgerter Dualzhler auf dem Port B und C mit Dunkelsteuerung
        clr     zaehl           ; Zhler lschen
loop:   mov     akku,zaehl      ; R16 <- Dualzahl
        Mdual2bcd  zaehl,hund,zehn,ein ; dual -> BCD
        tst     hund            ; Hunderter Null ?
        brne    loop1           ; nein: Stelle bleibt
        ori     hund,0b00001111 ;   ja: Hunderter dunkel steuern
        tst     zehn            ; auch Zehner Null ?
        brne    loop1           ; nein: Stelle bleibt
        ori     zehn,0b00001111 ;   ja: Stelle dunkel steuern
loop1:  ori     hund,0b11110000 ; linke Stelle immer dunkel steuern
        out     PORTB,hund      ; PORTB <- Hunderter
        swap    zehn            ; Zehner nach links
        or      zehn,ein        ; Zehner Einer zusammengesetzt
        out     PORTC,zehn      ; Zehner Einer ausgeben 
        ldi     akku,50         ; Faktor 50 fr 1 sek Wartezeit
loop2:  rcall   warte20ms       ; 16bit Wartezhler wartet ca. 20 ms
        dec     akku            ; Wartezeit vermindern
        brne    loop2           ; bis ca. 1 sek vergangen
        inc     zaehl           ; Zhler erhhen
        rjmp    loop            ; nein: Schleife
; Unterprogramme werden hier eingefgt
        .INCLUDE "warte20ms.asm"; 16bit Zhler wartet ca. 20 ms
       .EXIT                    ; Ende des Quelltextes

