

; test17.asm Test der BCD-Arithmetik
; Port B: - 
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
        .INCLUDE "m16def.inc"    ; Deklarationen fr ATmega16
        .INCLUDE "Mkonsole.h"    ; Makros mit Konsolfunktionen
        .INCLUDE "Mbcd.h"        ; Makros Dezimalkorrektur Mdaa und Mdas
        .EQU    TAKT = 8000000   ; Systemtakt 8 MHz
        .EQU    NPUF = 80        ; Lnge des Eingabepuffers
        .DEF    akkul = r16      ; Arbeitsregister Low
        .DEF    akkuh = r17      ; Arbeitsregister High
        .CSEG                    ; Programm-Flash
         rjmp   start            ; Reset-Einsprung
        .ORG    $2A              ; Interrupteinsprnge bergehen
start:   ldi    akkul,LOW(RAMEND) ; Stapelzeiger laden
         out    SPL,akkul        ;
         ldi    akkul,HIGH(RAMEND);
         out    SPH,akkul        ;
         Minituart 9600          ; USART 9600 Baud bei Frequenz TAKT
         ldi    ZL,LOW(prompt*2) ; Z <- Adresse Ausgabetext
         ldi    ZH,HIGH(prompt*2);
; Arbeitsschleife 
loop:    rcall  puts             ; Prompt: Eingabe -> 
         ldi    YL,LOW(puffer)   ; Y <- Adresse Eingabepuffer
         ldi    YH,HIGH(puffer)  ;
         rcall  gets             ; Eingabezeile nach Puffer Ende mit cr
         rcall  einbcd           ; R17:R16 <- Eingabewert
         brcc   next1            ; C = 0: kein Eingabefehler
         rjmp   error            ;
next1:   movw   r19:r18,r17:r16  ; R19:R18 <- 1.Operand
         movw   r21:r20,r17:r16  ; R21:R20 <- 1.Operand
         rcall  puts             ; Prompt: Eingabe -> 
         ldi    YL,LOW(puffer)   ; Y <- Adresse Eingabepuffer
         ldi    YH,HIGH(puffer)  ;
         rcall  gets             ; Eingabezeile nach Puffer Ende mit cr
         rcall  einbcd           ; R17:R16 <- Eingabewert
         movw   r23:r22,r17:r16  ; R23:R22 <- 2.Operand
         brcc   next2            ; C = 0: kein Eingabefehler
         rjmp   error            ;
next2:   Mputkon '+'             ;
; Test der vierstelligen Addition
         add    r16,r18          ; Low addieren
         rcall  daa              ; R16 korrigieren
         adc    r17,r19          ; High mit bertrag addieren
         Mdaa   r17              ; R17 korrigieren
         brcs   error            ; berlauf
         rcall  ausbcd           ; Summe ausgeben
         Mputkon '-'             ;
; Test der vierstelligen Subtraktion
         sub    r20,r22          ; Low subtrahieren
         Mdas   r20              ; und korrigieren
         sbc    r21,r23          ; High mit Borgen subtrahieren
         Mdas   r21              ; und korrigieren
         brcs   error            ; Unterlauf
         movw   r17:r16,r21:r20  ; 
         rcall  ausbcd           ; Differenz ausgeben
         rjmp   loop             ;
; Fehlermeldung
error:   Mputkon '?'               ;
         Mputkon 7               ;
         rjmp   loop             ;
; interne Unterprogramme fr Gert und Betriebsart
ausz:    Mputch r16              ; direkte Ausgabe nach USART
         ret                     ; 
einz:    ld     r16,Y+           ; gepufferte Eingabe von USART aus (Y)
         ret                     ; 
; externe Unterprogramme String und Umwandlung
         .INCLUDE "gets.asm"     ; Zeile von USART nach SRAM Adresse in Y
         .INCLUDE "puts.asm"     ; Text aus Flash ausgeben
         .INCLUDE "bcd.h"        ; BCD-Unterprogramme daa das einbcd ausbcd
;
; Ausgabetext
prompt:  .DB     10,13,"Eingabe -> ",0
; SRAM-Bereich 
         .DSEG                   ; Datenbereich
puffer:  .BYTE   NPUF            ; Eingabepuffer fr gets
         .EXIT                   ; Ende des Quelltextes


