

; k7p4.asm ATtiny12 Wrfel mit Sonderfunktion 1..7
; Port B: PB0..PB3: LED-Ausgabe Katoden  PB4: Tasteneingabe
        .INCLUDE "tn12def.inc"  ; Deklarationen fr Tiny12
        .EQU    TAKT = 1000000  ; interner Takt 1 MHz
        .DEF    akku = r16      ; Arbeitsregister 
        .DEF    zaehl = r17     ; laufender Zhler
        .DEF    anz = r18       ; Zhlerendwert 6 oder 7
; Tiny12: Makrodefinitionen ersetzen adiw und sbiw 
        .MACRO  Madiw           ; fr Befehl adiw Aufruf: RegL,RegH,konst
         subi   @0,-@2          ; addiere Konstante
         sbci   @1,-1           ; addiere Null + bertrag
        .ENDM                   ; Achtung: Flags invertiert!!!!
        .MACRO  Msbiw           ; fr Befehl sbiw Aufruf: RegL,RegH,konst
         subi   @0,@2           ; subtrahiere Konstante
         sbci   @1,0            ; subtrahiere Null und Borgen
         .ENDM                  ; Flags korrekt
        .CSEG                   ; Programmsegment
         rjmp    start           ; Einsprung nach Reset
        .ORG    $10             ; Interrupteinsprnge bergehen
; Tiny12: ohne SRAM kein Softwarestapel   Befehle push und pop ersetzen !!!
start:  ldi     akku,0b00001111 ; B7..B5 = x  B4 = ein  B3..B0 = aus
        out     DDRB,akku       ; Richtung Port B
 ; Endwert=6  wenn Taste bei Start gedrckt: Endwert=7
        ldi     anz,6           ; Endwert 6 vorgegeben
        sbis    PINB,PB4        ; berspringe wenn Taste PB4 oben
        ldi     anz,7           ; Low: gedrckt: 7er Wrfel
; Lampentest: alle Werte 500 ms lang anzeigen
        mov     zaehl,anz       ; laufender Zhler <= Endwert  
        ldi     ZL,LOW(tab*2)   ; Z <= Anfangsadresse der Tabelle
        ldi     ZH,HIGH(tab*2)  ;
        ldi     akku,50         ; Faktor fr 50*10 = 500 ms warten
haupt1: lpm                     ; R0 <= Tabellenwert
        Madiw   ZL,ZH,1         ; Makroaufruf: nchste Adresse
        com     r0              ; Logik umdrehen wegen Katodenansteuerung
        out     PORTB,r0        ; Wert anzeigen
        rcall   wartex10ms      ; 500 ms warten
        dec     zaehl           ; Durchlaufzhler - 1
        brne    haupt1          ; fr alle Werte
        ldi     akku,$ff        ; alle LEDS
        out     PORTB,akku      ; wieder aus
; Anfangswerte der Wrfelschleife laden
haupt2: mov     zaehl,anz       ; 1 Takt: laufender Zhler <= Endwert  
        ldi     ZL,LOW(tab*2)   ; 1 Takt: Z <= Anfangsadresse der Tabelle
        ldi     ZH,HIGH(tab*2)  ; 1 Takt:
; Wrfelschleife mit Tastenkontrolle
haupt3: sbis    PINB,PINB4      ; Taste gedrckt fallende Flanke
        rjmp    haupt4          ;   ja: ausgeben
        Madiw   ZL,ZH,1         ; nein: Makroaufruf: Adresse + 1
        dec     zaehl           ; Zhler - 1
        breq    haupt2          ; 2 Takte bei Sprung  1 Takt bei Nicht-Spr.
        nop                     ; 1 Takt Zeitausgleich
        nop                     ; 1 Takt
        rjmp    haupt3          ; 2 Takte
; fallende Flanke Taste gedrckt: Augen anzeigen
haupt4: lpm                     ; R0 <= Tabelle
        com     r0              ; Logik umdrehen wegen Katodenansteuerung
        out     PORTB,r0        ; und auf LED ausgeben 
        ldi     akku,2          ; Ladefaktor fr 2*10 = 20 ms warten
        rcall   wartex10ms      ; Wartefunktion 20 ms entprellen
haupt5: sbis    PINB,PINB4      ; steigende Flanke ?
        rjmp    haupt5          ; nein: warten
        rcall   wartex10ms      ;   ja: 20 ms entprellen
        ldi     akku,$ff        ;   alle LEDs aus
        out     PORTB,akku      ;
        rjmp    haupt2          ; neues Wrfeln
; internes Unterprogramm ersetzt push und pop
; wartex10ms.asm wartet 10 ms * Faktor in R16
wartex10ms:
        tst     r16              ; Null abfangen
        breq    wartex10msc      ; bei Null Rcksprung
        mov     r1,r16           ; push   r16   Register retten
        mov     r2,r24           ; push   r24
        mov     r3,r25           ; push   r25 
wartex10msa:
        ldi     r24,LOW(TAKT/400)  ; 20 MHz gibt
        ldi     r25,HIGH(TAKT/400) ; Ladewert 50 000
wartex10msb:
        Msbiw   r24,r25,1        ; 2 Takte
        brne    wartex10msb      ; 2 Takte
        dec     r16              ; Zhler vermindern
        brne    wartex10msa      ;
        mov     r25,r3           ; pop    r25 Register zurck
        mov     r24,r2           ; pop    r24 
        mov     r16,r1           ; pop    r16
wartex10msc:
          ret                       ; 
; Tabelle fr Lampentest:  1 2 3 4  5  6  7
tab:    .DB    $01, $02, $03, $06, $07, $0e , $0f, 0 ; Ausgabemuster 
        .EXIT                   ; Ende des Quelltextex

