

; k5p1.asm  ATmega8  Boot-Lader One-Task-Version
; Port B: - 
; Port C: -
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .EQU    baud = 9600     ; Baudrate
        .EQU    LAENG = 1000    ; Lnge des SRAM-Puffers
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        .ORG    LARGEBOOTSTART  ; Startvektor nach $0C00 verlegt
        rjmp    start           ; Reset-Einsprung
        rjmp    $001            ; INT0
        rjmp    $002            ; INT1
        rjmp    $003            ; OCR2
        rjmp    $004            ; OVF2
        rjmp    $005            ; ICP1
        rjmp    $006            ; OCP1A
        rjmp    $007            ; OCP1B
        rjmp    $008            ; OVF1
        rjmp    $009            ; OVF0
        rjmp    $00A            ; SPI
        rjmp    $00B            ; URXC
        rjmp    $00C            ; UDRE
        rjmp    $00D            ; UTXC
        rjmp    $00E            ; ADC
        rjmp    $00F            ; ERDY
        rjmp    $010            ; ACI
        rjmp    $011            ; TWI
        rjmp    $012            ; SPM
start:  cli                     ; alle Interrupts gesperrt
        ldi     akku,LOW(RAMEND); Stapel anlegen am SRAM-Ende
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ;        
        rcall   initusart2      ; USART initialisieren doppelte Baudrate
neu:    ldi     ZL,LOW(meldung*2) ; Prompt und 
        ldi     ZH,HIGH(meldung*2); Funktion 
        rcall   puts            ;   anfordern
loop:   rcall   getch           ; R16 = Kennbuchstabe
        andi    r16,~$20        ; klein -> Gross
        cpi     r16,'S'         ; S fr Start ?
        brne    loop1           ;
        rjmp    sfunc           ;
loop1:  cpi     r16,'L'         ; L fr Laden ?
        brne    loop2           ;
        rjmp    lfunc           ;
loop2:  cpi     r16,'R'         ; TEST R fr SRAM-Ausgabe
        brne    loop3           ; 
        rjmp    rfunc           ; 
loop3:  cpi     r16,'F'         ; TEST F fr Flash-Ausgabe
        brne    loop4           ;
        rjmp    ffunc           ;
loop4:  rjmp    loop            ; kein Kennbuchstabe: neue Eingabe
;
; Startfunktion immer ab $000 Benutzer-Flash
sfunc:  rcall   putch           ; Echo
        ldi     akku,10         ; 10 * 10 = 100 ms warten
        rcall   wartex10ms      ;
        ldi     ZL,0            ; Z <- Startadresse $000
        ldi     ZH,0            ;
        ijmp                    ; indirekter Sprung
;
; Ladefunktion immer nach $000 mit $FF vorbesetzen
lfunc:  rcall   putch           ; Echo
        ldi     XL,LOW(puff)    ; X = Eingabepuffer im SRAM
        ldi     XH,HIGH(puff)   ;
        ldi     YL,LOW(LAENG)   ; Y = Bytezhler 
        ldi     YH,HIGH(LAENG)  ;
        ldi     r16,$FF         ;
lfunc0: st      X+,r16          ; Puffer mit $FF vorbesetzen
        sbiw    YL,1            ;
        brne    lfunc0          ; 
        ldi     XL,LOW(puff)    ; X = Eingabepuffer im SRAM
        ldi     XH,HIGH(puff)   ;
        clr     r24             ; R25:R24 = hchste Ladeadresse
        clr     r25             ; im Flash
        clr     r23             ; R23 = Lnge des Datensatzes
        ldi     ZL,LOW(meldung1*2)  ; Z = Ladedatei anfordern
        ldi     ZH,HIGH(meldung1*2) ;
        rcall   puts            ;
; warte auf Satzanfangsmarke :
lfunc1: rcall   getche          ; R16 = Zeichen
        cpi     r16,':'         ; Satzanfangsmarke ?
        brne    lfunc1          ; nein
; Zhler, Adresse und Satztyp lesen
        rcall   getbyte         ; R16 <- Zhlerbyte
        brcc    PC+2            ; 
        rjmp    lfuncerr        ; Eingabefehler
        mov     r17,r16         ; R17 <- Bytezhler
        rcall   getbyte         ; R16 <- Adresse High
        brcc    PC+2            ;
        rjmp    lfuncerr        ; Eingabefehler
        mov     XH,r16          ; XH  <- Adresse High
        rcall   getbyte         ; R16 <- Adresse Low
        brcc    PC+2            ;
        rjmp    lfuncerr        ; Eingabefehler
        mov     XL,r16          ; XL  <- Adresse Low
        cp      XL,r24          ; hchste Ladeadresse merken
        cpc     XH,r25          ; aktuelle - max. Adresse
        brlo    lfunc1a         ;        kleiner: weiter
        mov     r24,XL          ; grsser/gleich: merken
        mov     r25,XH          ;
        mov     r21,r17         ; R21 = Lnge des Satzes
lfunc1a:subi    XL,LOW(-puff)   ; + Anfangsadresse SRAM 
        sbci    XH,HIGH(-puff)  ;
        rcall   getbyte         ; R16 <- Typ
        brcc    PC+2            ; 
        rjmp    lfuncerr        ; Eingabefehler
        mov     r18,r16         ; R18 <- Satztyp
        cpi     r18,0           ; Datensatz ?
        breq    lfunc4          ; ja:
        cpi     r18,1           ; Endesatz ?
        breq    lfunc3          ; ja:
        cpi     r18,2           ; Segmentsatz ?
        breq    lfunc2          ; ja:
        rjmp    lfuncerr        ; kein Satztyp
;
; Typ 2 Segmentsatz ignorieren
lfunc2: rcall   getbyte         ; Segment Low
        rcall   getbyte         ; Segment High
        rcall   getbyte         ; Prfsumme
        rjmp    lfunc1          ; neuer Satz
;
; Typ 1 Endesatz 
lfunc3: rcall   getbyte         ; Prfsumme
        rjmp    lfunc7          ; nun geht es zum Brennen
;
; Typ 0 Datensatz lesen und nach SRAM speichern
lfunc4: ldi     r22,LOW(RAMEND-$30)  ; Kontrolle SRAM-berlauf
        ldi     r23,HIGH(RAMEND-$30) ; Stapel = $30 Bytes
        cp      XL,r22          ;
        cpc     XH,r23          ;
        brlo    lfunc5          ; Adresse < Endadresse
        rjmp    lfuncerr        ; Adresse >= Endadresse: Fehler
lfunc5: tst     r17             ; R17 = Bytezhler ?
        breq    lfunc6          ; Ende des Datensatzes
        rcall   getbyte         ; R16 <- Datenbyte
        brcc    PC+2            ;
        rjmp    lfuncerr        ; Eingabefehler
        st      X+,r16          ; nach Puffer SRAM
        dec     r17             ; Zhler - 1
        rjmp    lfunc5          ;
lfunc6: rcall   getbyte         ; Prfsumme ignorieren
        rjmp    lfunc1          ; neuen Satz lesen
;
; von Eingabepuffer SRAM nach Flash brennen
lfunc7: add     r24,r21         ; hchste Ladeadresse + Satzlnge
        clr     r21             ;
        adc     r25,r21         ; R25:R24 hchste Ladeadresse
; TEST hchste Ladeadresse R25:R24 ausgeben
        ldi     r16,10          ; cr
        rcall   putch           ;
        ldi     r16,13          ; lf
        rcall   putch           ;
        mov     r16,r25         ; High-Byte
        rcall   putbyte         ;
        mov     r16,r24         ; Low-Byte
        rcall   putbytb         ; 
        ldi     r16,' '         ; Leerzeichen
        rcall   putch           ; ausgeben
; Anzahl der Seiten berechnen    
        lsl     r24             ; hchste Ladeaadresse
        rol     r25             ;
        lsl     r24             ; Seiten berechnen
        rol     r25             ;
        mov     r19,r25         ;
        inc     r19             ; R19 = Seitenzhler 64 Bytes/Seite
        clr     ZL              ; Z = Flash-Byte-Adresse ab $000
        clr     ZH              ;
        ldi     XL,LOW(puff)    ; X = SRAM-Pufferadresse
        ldi     XH,HIGH(puff)   ;
        ldi     YL,LOW(PAGESIZE*2) ; Y = Bytes/Seite
        ldi     YH,HIGH(PAGESIZE*2); 
; 
; Seitenschleife: Seite lschen Adresse in Z
lfunc8: ldi     r16,(1<<PGERS) | (1<<SPMEN) ; Seite lschen
        rcall   spmexe          ; ausfhren und warten
;64 Bytes vom SRAM-Puffer nach Seiten-Puffer
        ldi     r20,PAGESIZE    ; 32 Wrter
lfunc10:ld      r0,X+           ; R0 <- Low-Byte
        ld      r1,X+           ; R1 <- High-Byte
        ldi     r16,(1 << SPMEN); Puffer schreiben
        rcall   spmexe          ; ausfhren und warten
        adiw    ZL,2            ; Flash-Adresse + 2
        dec     r20             ; Bytezhler - 1
        brne    lfunc10         ; bis Seiten-Puffer gefllt
; Puffer nach Flash schreiben
        sub     ZL,YL           ; alte Flash-Adresse
        sbc     ZH,YH           ;
        ldi     r16,(1 << PGWRT) | (1 << SPMEN) ; Puffer -> Flash
        rcall   spmexe           ; ausfhren und warten
        add     ZL,YL            ; neue Seite
        adc     ZH,YH            ; 
; Schleifenkontrolle fr alle Seiten
        ldi     r16,'*'          ; * fr Seite
        rcall   putch            ; ausgeben
        dec     r19              ; Seitenzhler - 1
        brne    lfunc8           ; nchste Seite
; RWW freigeben
        ldi     r16,(1 << RWWSRE) | (1 << SPMEN) ; Freigabe
        rcall   spmexe           ; ausfhren und warten
        rjmp    neu              ; neue Funktion anfordern
; Unterprogramm SPM-Funktion ausfhren R16 = Code
spmexe: out     SPMCR,r16        ;
        spm                      ;
spmexe1:in      r16,SPMCR        ;
        sbrc    r16,SPMEN        ; warte solange Funktion ausgefhrt
        rjmp    spmexe1          ;
        ret                      ;
;
; Eingabefehler
lfuncerr:
        ldi     r16,100         ; 1 sek warten
        rcall   wartex10ms      ;
        ldi     ZL,LOW(fehler*2) ; Fehlermeldung
        ldi     ZH,HIGH(fehler*2); 
        rcall   puts            ;
        rjmp    start           ; neue Grundstellung
; Hilfsfunktionen fr Speicherkontrolle
; >R   SRAM-Ausgabe 16 * 16 = 256 Bytes
rfunc:  rcall   putch           ; Echo
        ldi     ZL,LOW(puff)    ; Z = Speicheradresse
        ldi     ZH,HIGH(puff)   ; 
rfunc1: ldi     r19,16          ; R19 = Zeilenzhler
rfunc2: ldi     r18,16          ; R18 = Bytezhler / Zeile
        ldi     r16,10          ; cr
        rcall   putch           ;
        ldi     r16,13          ; lf
        rcall   putch           ;
        mov     r16,ZH          ; laufende Adresse
        rcall   putbyte         ;
        mov     r16,ZL          ;
        rcall   putbytb         ; 
rfunc3: ld      r16,Z+          ; Byte
        rcall   putbyte         ;  
        dec     r18             ; Bytezhler
        brne    rfunc3          ;
        dec     r19             ; Zeilenzhler
        brne    rfunc2          ;
        ldi     r16,' '         ;
        rcall   putch           ;
        ldi     r16,'>'         ;
        rcall   putch           ;
        rcall   getch           ;
        cpi     r16,13          ; cr = Abbruch?
        brne    rfunc1          ; nein: weiter
rfunc4: rjmp    neu             ;   ja: Abbruch
; >F   Flash-Ausgabe 16 * 16 = 256 Bytes
ffunc:  rcall   putch           ; Echo
        ldi     ZL,0            ; Z = Flash ab $000
        ldi     ZH,0   ; 
ffunc1: ldi     r19,16          ; R19 = Zeilenzhler
ffunc2: ldi     r18,16          ; R18 = Bytezhler / Zeile
        ldi     r16,10          ; cr
        rcall   putch           ;
        ldi     r16,13          ; lf
        rcall   putch           ;
        mov     r16,ZH          ; laufende Adresse
        rcall   putbyte         ; Leerzeichen und Byte
        mov     r16,ZL          ;
        rcall   putbytb         ; nur Byte
ffunc3: lpm     r16,Z+          ; R16 = Byte Z = Z + 1
        rcall   putbyte         ; ausgeben
        dec     r18             ; Bytezhler
        brne    ffunc3          ;
        dec     r19             ; Zeilenzhler
        brne    ffunc2          ;
        ldi     r16,' '         ;
        rcall   putch           ;
        ldi     r16,'>'         ;
        rcall   putch           ;
        rcall   getch           ;
        cpi     r16,13          ; cr = Abbruch?
        brne    ffunc1          ; nein: weiter
ffunc4: rjmp    neu             ;   ja: Abbruch ;
; interne Unterprogramme
; getbyte = zwei Hexazeichen lesen Carry = 1: Nicht-Hexazeichen
getbyte:push     r19            ; Register retten
        rcall    getnib         ; R16 = 0000 Halbbyte rechts
        mov      r19,r16        ; 
        swap     r19            ; R19 = Halbbyte 0000
        rcall    getnib         ; R16 = 0000 Halbbyte rechts
        or       r16,r19        ; R16 = Byte
        pop      r19            ; Register zurck
        ret                     ;
; getnib = ein Hexazeichen lesen und decodieren C = 1: Nicht-Hexazeichen
getnib: rcall    getche         ; Zeichen mit Echo lesen
        cpi      r16,'0'        ; 
        brlo     getnib3        ; Fehlerausgang
        cpi      r16,'9'+1      ;
        brsh     getnib1        ;
        subi     r16,'0'        ; 0 - 9 decodieren
        rjmp     getnib2        ;
getnib1:andi     r16,~$20       ; klein -> gross
        cpi      r16,'A'        ; 
        brlo     getnib3        ; Fehlerausgang
        cpi      r16,'F'+1      ;
        brsh     getnib3        ; Fehlerausgang
        subi     r16,'A'-10     ; A - F decodieren
getnib2:clc                     ; C = 0: Gut-Marke
        ret                     ;
getnib3:clr      r16            ; Ergebnis lschen
        sec                     ; C = 1: Fehlermarke
        ret                     ;
; putbyte Byte und Leerzeichen ausgeben fr R- und F-Funktionen
putbyte:push     r16            ;
        ldi      r16,' '        ; Leerzeichen
        rcall    putch          ; ausgeben
        pop      r16            ; 
putbytb:push     r16            ; Einsprung ohne Leerzeichen
        swap     r16            ; High-Nibble zuerst
        andi     r16,$0F        ; 
        rcall    putnib         ;
        pop      r16            ; dann Low-Nibble
        andi     r16,$0F        ;
        rcall    putnib         ;
        ret                     ;
putnib: subi     r16,-$30       ; addi R16,$30 nach ASCII
        cpi      r16,'9'+1      ;
        brlo     putnib1        ; war 0-9
        subi     r16,-7         ; addi R16,7 nach ASCII
putnib1:rcall    putch          ; Zeichen ausgeben
        ret                     ;
;
; externe Konsolunterprogramme einfgen
       .INCLUDE "initusart2.asm"; USART initialisieren doppelte Baudrate
       .INCLUDE "putch.asm"     ; Zeichen aus R16 senden
       .INCLUDE "puts.asm"      ; String aus (Z) senden
       .INCLUDE "getch.asm"     ; Zeichen nach R16 ohne Echo
       .INCLUDE "getche.asm"    ; Zeichen nach R16 mit Echo
       .INCLUDE "wartex10ms.asm"; R16 = Faktor * 10ms
;
; Ausgabetexte
meldung: .DB 10,13,"Boot-Lader 1.0"
         .DB 10,13,"Funktion L=Laden S=Starten L/S >",0,0 
meldung1:.DB 10,13,"      Ladedatei xxxx.HEX senden!",10,13,0,0
fehler:  .DB 10,13,"Abbruch wegen Eingabefehler!!!!!",10,13,0,0
;
; Datenbereich im SRAM als Eingabepuffer
       .DSEG                    ;
puff:  .BYTE     LAENG          ; LAENG als Symbol vereinbart
       .EXIT                    ; Ende des Quelltextes

