

; k4p3.asm Timer0 Flankenzhler externer Takt an T0 (PD4)
; Port B: Ausgabe            Zehner Einer
; Port C: Ausgabe Hunderter
; Port D: PD4 = T0 = externer Takt durch Taster
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
; Timer0 programmieren
        ldi     akku,0b110      ; extener Takt fallende Flanke T0 
        out     TCCR0,akku      ; Steuerregister Timer0
        clr     akku            ;
        out     TCNT0,akku      ; Flankenzhler Timer0 lschen
; Arbeitsschleife gibt laufenden Flankenzhler Timer0 aus
loop:   in      akku,TCNT0      ; Zhler nach R16 fr Dezimalumwandlung
        rcall   dual2bcd        ; nach BCD R17:R16 umwandeln
        out     PORTB,r16       ; Zehner und Einer nach Port B
        out     PORTC,r17       ; Hunderter nach Port C
        rjmp    loop            ; 
; dual2bcd: Umwandlung R16 dual nach BCD dreistellig 
       .INCLUDE "dual2bcd.asm"  ; R16 dual -> R17 Hunderter R16 Zehner | Einer
       .EXIT                    ; Ende des Quelltextes


