

; k4p19.asm  ATmega8 TWI-Schnittstelle (I2C) 
; Port B: Ausgabe der empfangenen Daten 
; Port C: PC1=SDA PC0=SCL an PCF8574A 8bit I/O
; Port D: Eingabe senden nach 8bit I/O Ausgabeeinheit
; Konfiguration: interner Takt 1 MHz, externes Reset-Signal
        .INCLUDE "m8def.inc"      ; Deklarationen
        .EQU      TAKT = 1000000  ; Systemtakt 1 MHz
        .EQU      ausad = $70     ; Adresse Ausgabeeinheit
        .EQU      einad = $71     ; Adresse Eingabeeinheit
        .DEF      akku = r16      ; fr Daten
        .DEF      addr = r17      ; fr Adressen
        .CSEG                     ; Programmsegment
        rjmp      start           ; Einsprung nach Reset
        .ORG      $2A             ; keine Interrupts
start:  ldi       akku,LOW(RAMEND); Stapel anlegen
        out       SPL,akku        ;
        ldi       akku,HIGH(RAMEND); 
        out       SPH,akku        ;
        ldi       akku,$ff        ;
        out       DDRB,akku       ; Port B ist Ausgabe
        ldi       akku,10         ; Bitrate fr Bustakt SCL ca. 10kHz
        ldi       addr,$1         ; Code 0 1 Vorteiler 
        rcall     init            ; TWI initialisieren
schlei: ldi       addr,ausad      ; R17 = Adresse Ausgaberegister
        in        akku,PIND       ; R16 = Ausgabedaten
        com       akku            ; Komplement
        rcall     send            ; TWI senden
        ldi       addr,einad      ; R17 = Adresse Eingaberegister
        rcall     empf            ; TWI empfangen
        out       PORTB,akku      ; Kontrollausgabe PORT B
        rjmp      schlei          ; Arbeitsschleife
; Unterprogramme
; init R16 = Bitratenfaktor r17 = Vorteiler
init:   out       TWBR,r16        ; Bitrate
        out       TWSR,r17        ; Vorteiler
        ret                       ; Rcksprung
;
; send R17 = Slaveadresse  R16 = Ausgabedaten
send:   push      r18             ; Register retten
; Startbedingung ausgeben ohne Statuskontrolle
        ldi       r18,(1<<TWINT) | (1<<TWSTA) | (1<<TWEN) ;
        out       TWCR,r18        ; Startbedingung ausgeben
send1:  in        r18,TWCR        ; Steuerregister lesen
        sbrs      r18,TWINT       ; berspringe wenn fertig
        rjmp      send1           ; warte solange TWINT = 0
; Slaveadresse R17 ausgeben ohne Statuskontrolle
        out       TWDR,r17        ; R17 = Slaveadrresse
        ldi       r18,(1<<TWINT) | (1<<TWEN) ;
        out       TWCR,r18        ; Slaveadresse ausgeben
send2:  in        r18,TWCR        ; Steuerregister lesen
        sbrs      r18,TWINT       ; berspringe wenn fertig
        rjmp      send2           ; warte solange TWINT = 0
; Daten R16 senden ohne Statuskontrolle
        out       TWDR,r16        ; R16 = Daten an Slave
        ldi       r18,(1<<TWINT) | (1<<TWEN) ;
        out       TWCR,r18         ; 
send3:  in        r18,TWCR         ; Steuerregister lesen
        sbrs      r18,TWINT        ; berspringe wenn fertig
        rjmp      send3            ; warte solange TWINT = 0
; Stoppbedingung ausgeben
        ldi       r18,(1<<TWINT) | (1<<TWSTO) | (1<<TWEN) ;
        out       TWCR,r18         ; Stoppbedingung ausgeben
        pop       r18              ; Register zurck
        ret                        ; Rcksprung
;
; empf R17 = Slaveadresse Rckgabe R16 <= empfangene Daten
empf:   push      r18              ; Register retten
; Startbedingung ausgeben ohne Statuskontrolle
        ldi       r18,(1<<TWINT) | (1<<TWSTA) | (1<<TWEN) ; 
        out       TWCR,r18         ; Startbedingung ausgeben
empf1:  in        r18,TWCR         ; Steuerregister lesen
        sbrs      r18,TWINT        ; berspringe wenn fertig
        rjmp      empf1            ; warte solange TWINT = 0
; Slaveadresse R17 ausgeben ohne Statuskontrolle 
        out       TWDR,r17         ; R17 = Slaveadresse
        ldi       r18,(1<<TWINT) | (1<<TWEN) ;
        out       TWCR,r18         ; Slaveadresse ausgeben
empf2:  in        r18,TWCR         ; Steuerregister lesen
        sbrs      r18,TWINT        ; berspringe wenn fertig
        rjmp      empf2            ; warte solange TWINT = 0
; Daten nach R16 empfangen ohne Statuskontrolle
        ldi       r18,(1<<TWINT) | (1<<TWEN) ;
        out       TWCR,r18         ; 
empf3:  in        r18,TWCR         ; Steuerregister lesen
        sbrs      r18,TWINT        ; berspringe wenn fertig
        rjmp      empf3            ; warte solange TWINT = 0
        in        r16,TWDR         ; R16 <= Daten
; Besttigungsimpuls an Sender ohne Statuskontrolle
        ldi       r18,(1<<TWINT) | (1<<TWEA) | (1<<TWEN);
        out       TWCR,r18         ;
empf4:  in        r18,TWCR         ; Steuerregister lesen
        sbrs      r18,TWINT        ; berspringe wenn fertig
        rjmp      empf4            ; warte solange TWINT = 0
; Stoppbedingung ausgeben
        ldi       r18,(1<<TWINT) | (1<<TWSTO) | (1<<TWEN)
        out       TWCR,r18         ; Stoppbedingung ausgeben
        pop       r18              ; Register zurck
        ret                        ; Rcksprung
        .EXIT                      ; Ende des Quelltextes

