

; k4p16a.asm  ATmega8  USART Test der Software-Emulation
; Port B: - 
; Port C: -
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .EQU    baud = 9600     ; Baudrate
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ;        
        rcall   softinit        ; USART initialisieren 
neu:    ldi     akku,'>'        ; Prompt >
        rcall   softputch       ;  ausgeben
loop:   rcall   softgetch       ; Zeichen ohne Echo empfangen
        rcall   softputch       ; Echo senden
        rjmp    loop            ; und neue Eingabe
; Software-Konsolunterprogramme einfgen
       .INCLUDE "softkonsole.h" ; softinit,softputch,softgetch,softgetche
        .EXIT                   ; Ende des Quelltextes

