

; k4p13.asm ATmega8  Ruhezustand (Sleep Mode)
; Port B: Dualzhler 
; Port C: -
; Port D: Taste PD3 INT1 weckt und erhht Dualzhler
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    INT1addr        ; Einsprung externer Interrupt INT1
        rjmp     taste          ; nach Servicprogramm
        .ORG    $13             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        clr     akku            ; Dualzhler lschen
        out     PORTB,akku      ; und Anfangswert ausgeben
; Ruhezustand Sleep Mode 000 idle vorbereiten
        in      akku,MCUCR      ;
        ori     akku,(1 << SE) | (0 << SM2) | (0 << SM1) | (0 << SM0);
        out     MCUCR,akku      ;
; Interrupt INT1 initialisieren
        in      akku,MCUCR      ; altes Steuerregister
        sbr     akku,1 << ISC11 ; setze  Bit ISC11
        cbr     akku,1 << ISC10 ; lsche Bit ISC10
        out     MCUCR,akku      ; ISC1x: 1 0 INT1 fallende Flanke
        in      akku,GICR       ; altes Freigaberegister
        sbr     akku,1 << INT1  ; setze Bit INT1: 
        out     GICR,akku       ; Interrupt INT1 freigegeben
        sei                     ; alle Interrupts global frei
; Hauptprogramm schlft vor sich hin
loop:   rjmp    loop            ; tu nix
;
; Serviceprogramm bedient externen Interrupt INT1 Taste PD3
taste:  push    r16             ; Register retten
        in      r16,SREG        ; Status 
        push    r16             ; retten
        in      r16,PORTB       ; alten Zhler
        inc     r16             ; um 1 erhhen
        out     PORTB,r16       ; neuen Zhler ausgeben
        pop     r16             ; 
        out     SREG,r16        ; Status zurck
        pop     r16             ;
        reti                    ; Rcksprung aus Serviceprogramm
        .EXIT                   ; Ende des Quelltextes

