



// k7p11.c ATmega16 Test Pseudo-Zufallszahlen
// Port A: Ausgabe High-Byte 
// Port B: Ausgabe Middle-High-Byte
// Port C: Ausgabe Middle-Low-Byte
// Port D: Ausgabe Low-Byte
// Konfiguration Quarz 3.6864 MHz  JTAG Interface disabled! 
#define     TAKT 3686400ul     // Systemtakt 3.6864 MHz
#include    <avr/io.h>         // Deklarationen
#include    "wartex10ms.c"     // wartet faktor*10ms Symbol TAKT
#include    "randomize.c"      // Startzahl
#include    "random.c"         // neue Zufallszahl
unsigned long int zufall = 0x12345678;    // 32bit laufende Zufallszahl
void main (void)                           // Hauptfunktion
{
 DDRA = DDRB = DDRC = DDRD = 0xff;          // Ausgabe fr Ports A, B, C, D 
 randomize(&zufall);
 while (1)                                 // Arbeitsschleife tut nix
 {
  PORTA = (unsigned char) (zufall >> 24); // Ausgabe High-Byte
  PORTB = (unsigned char) (zufall >> 16); // Ausgabe Middle-High-Byte
  PORTC = (unsigned char) (zufall >> 8);  // Ausgabe Middle-Low-Byte
  PORTD = (signed char) zufall;            // Ausgabe Low-Byte
  wartex10ms(10);                           // 100 ms warten
  random(&zufall);                          // neue Zufallszahl
 } // Ende while
} //Ende main


