


// k6p5.c ATmega8 Test PC-Tastatur und LCD-Anzeige 
// Port B: LCD-Anzeige: PB1: E-Signal
// Port B: PC-Tastatur: PB5: Takt  PB3: Daten
// Port D: LCD-Anzeige: PD7 PD6 PD5 PD4 (4bit)   PD3: RS-Signal
#include <io.h>                  // Deklarationen  
#define TAKT 8000000ul           // Systemtakt Quarz 8 MHz
// Symboldefinitionen fr LCD-Schnittstelle 4bit Bus an High-Port und PC-Tastatur
#define LCDPEN  PORTB            // Port des E-Signals
#define LCDEN   PB1              // Bit E Freigabsignal 
#define LCDPRS  PORTD            // Port des RS-Signal
#define LCDRS   PD3              // Bit RS Registerauswahlsignal
#define LCDPDAT PORTD            // Port des 4bit-Datenbus
#define LCDBUS 'h'               // Anschluss an High-Port PB7..PB4
#define PCPORT  PINB             // Port des PC-Anschlusses
#define PCTAKT  PB5              // Bit PC-Takteingang
#define PCDAT   PB3              // Bit PC-Dateneingang
unsigned char curpos = 0, zustand = 0; // Cursorposition und Tastaturzustand
// externe LCD- und Tastaturfunktionen
#include  "lcd4.h"               // fgt warte1ms und LCD-Funktionen ein
#include  "pctast.c"             // Funktion pctast liefert ASCII- und Scan-Code 
void ausz(unsigned char zeichen) // Hilfsfunktion fr aushex8
{
 lcd4put(zeichen);               // Umleitung von aushex8 nach LCD-Anzeige
}
#include  "aushex8.c"            // Hexa-Ausgabe ruft ausz(Zeichen) auf

void main(void)                  // Hauptfunktion
{
 unsigned char ascii, scan;      // Variable ASCII-Code und Scan-Code
 DDRD = 0xf8;                    // 1111 1000 PD7 - PD3 sind Ausgnge
 LCDPEN &= ~(1 << LCDEN);        // PB1 Datenausgang LOW
 DDRB   |=  (1 << LCDEN);        // PB1: Ausgang LCD-/E-Signal  PB3 PB5 Eingnge
 lcd4ini();                      // LCD-Anzeige initialisieren
 while(1)                        // Arbeitsschleife
 {
  pctast(&ascii, &scan);         // warte bis Taste gelst liefert Codes
  aushex8(scan);                 // lz 0xss Scan-Code hexadezimal
  lcd4put(' ');                  // lz ausgeben
  if (ascii != 0) lcd4put(ascii); else lcd4put(0x40); // ASCII-Zeichen oder @
  lcd4put(' ');                  // lz ausgeben
 } // Ende while
} // Ende main




