

// k6p12.c  ATmega8  Schrittmotor  Steuerung 
// Port B: Ausgabe Schrittposition dezimal anzeigen
// Port C: Eingabe Schrittgeschwindigkeit
// Port D: Eingabe PD7 PD6  Ausgabe PD3-PD0
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>                  // Deklarationen
#define TAKT 1000000UL               // Systemtakt intern ca. 1 MHz
#include "wartex10ms.c"              // Wartet Faktor * 10 ms
void main(void)                      // Hauptfunktion
{ 
 unsigned char schritt = 0x11;      // 0001 0001 Schrittmuster
 unsigned char pos = 0;             // Position 
 PORTD = 0xf0;                       // 1111 0000 PD3-PD0 Daten Low
 DDRD = 0x0f;                        // 0000 1111 PD3-PD0 Richtung Ausgang
 DDRB = 0xff;                        // Port B ist Ausgang
 while(1)                            // Arbeitsschleife Eingabe Drehrichtung
 {
  while ( !(PIND & (1 << PD7)))      // solange PD7 gedrckt Linkslauf
  {
   schritt = (schritt << 1) | (schritt >> 7);  // rotiere 8bit links
   PORTD = schritt;                  // Schritt ausgeben
   pos++; PORTB = ((pos / 10) << 4) | (pos % 10);  // neue Position ausgeben
   wartex10ms(PINC);
  } //Ende while Linkslauf
  while ( !(PIND & (1 << PD6)))      // solange PD6 gedrckt Rechtslauf
  {
   schritt = (schritt >> 1) | (schritt << 7);  // rotiere 8bit rechts
   PORTD = schritt;                  // Schritt ausgeben
   pos--; PORTB = ((pos / 10) << 4) | (pos % 10);  // neue Position ausgeben
   wartex10ms(PINC);
  } // Ende while Rechtslauf
 } // Ende while
} // Ende main

