

// k4p26.c  ATmega16 parallele analoge Wandler
// Port B: 8bit Datenbus
// Port D: D7=Status D6=R/W D5=/CS=/CE D4=/E  D1=TXD D0=RXD
#include <avr/io.h>          // Deklarationen
#define TAKT 3686400UL       // Controllertakt 3.6864 MHz
#define BAUD 9600UL          // Baudrate
#include "inituart.c"        // UART initialisieren
#include "putch.c"           // Zeichen mit UART ausgeben
#include "getch.c"           // auf Zeichen warten
// Funktion Ausgabe 8bit dezimal auf Terminal
void termaus(unsigned char wert)
{
 putch(10); putch(13);         // neue Zeile
 putch( (wert/100) + 0x30);    // Hunderter
 putch( (wert%100)/10 + 0x30); // Zehner
 putch( (wert%100)%10 + 0x30); // Einer
 putch(' '); putch('>');       // Leerzeichen und Prompt
 getch();                      // warte auf Taste
} // Ende termaus
// Funktion 8bit parallele Eingabe von A/D-Wandler AD670
unsigned char parein(void)
{
 unsigned char wert, x;   // Hilfsvariable
 cbi(PORTD,PD6);          // R/W Low: fr starten
 cbi(PORTD,PD5);          // /CE=/CS Low
 x = PINB;                // Pseudolesen als Startimpuls
 x = PIND;                //
 sbi(PORTD,PD5);          // /CE=/CS High
 sbi(PORTD,PD6);          // R/W High fr lesen
 loop_until_bit_is_clear(PIND,PIND7); // warte auf fertig
 cbi(PORTD,PD5);          // /CE=/CS Low
 x = PINB;                // Pseudolesen zum warten 
 x = PIND;                // 
 wert = PINB;             // digitalen Wert abholen
 sbi(PORTD,PD5);          // /CE=/CS High 
 return wert;             // 
} // Ende parein
// Funktion parallele Ausgabe nach D/A-Wandler ZN428
void paraus(unsigned char wert)
{
 DDRB = 0xff;             // Port B ist Ausgabe
 PORTB = wert;            // Daten nach Bus
 cbi(PORTD,PD4);          //  /E Low
 wert = PINB;             // Pseudobefehl zum warten
 sbi(PORTD,PD4);          // /E wieder High
 DDRB = 0;                // Port B ist wieder Eingabe
} // Ende paraus
main(void)                // Hauptfunktion
{
 unsigned char wert;      // Hilfsvariable
 inituart();              // UART initialisieren
 DDRD = (1 << PD6) | (1 << PD5) | (1 << PD4);   // Richtung Port C
 PORTD = (1 << PD6) | (1 << PD5) | (1 << PD4);  // Ausgnge High
 while(1)                 // Arbeitsschleife
 {
  wert = parein();        // 8bit parallele Eingabe von A/D
  paraus(wert);           // 8bit parllele Ausgabe nach D/A
  termaus(wert);          // 8bit Ausgabe dezimal auf Terminal
 } // Ende while
} // Ende main
