

// k4p2.c Timer0 Sekundenzhler mit Interrupt
// Port B: Ausgabe            Zehner Einer
// Port C: Ausgabe Hunderter
// Port D: -
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>         // Deklarationen
#include <avr/signal.h>     // Deklarationen fr Interrupt
#include <avr/interrupt.h>  // Deklarationen fr Interrupt
#define TAKT 1000000UL      // Controllertakt 1 MHz
#define ZAEHL 61            // 1 MHz : 256 : 64 = 61.03 gerundet 61
#include "dual2bcd.c"       // dual -> BCD int (Hunderter Zehner Einer)
volatile unsigned char takt=ZAEHL, seku=0;  // globale Variable
// ISR (INT0_vect)          // neue Bezeichnung fr Interruptservice
SIGNAL (SIG_OVERFLOW0)      // bei Timer0 berlauf
{  
 takt--;                     // Interruptzhler - 1
 if(takt == 0)                   // nach 61 Durchlufen
 {
  takt = ZAEHL; seku++;         // wieder Anfangswert Zhler erhhen
  PORTC = dual2bcd(seku) >> 8;  // Port C Hunderter
  PORTB = dual2bcd(seku);       // Port B: Zehner Einer 
 } // Ende if takt
} // Ende SIGNAL
void main(void)          // Hauptfunktion
{
 DDRB = 0xff;             // Port B ist Ausgang
 DDRC = 0xff;             // Port C ist Ausgang
 TCCR0 |= 0x03;           // Teiler 64 = 011
 TIMSK |= (1 << TOIE0);  // Timer0 Interrupt frei
 PORTB = 0;              //  Port B 0 0
 PORTC = 0;               // Port C 0 0
 sei();                   // alle Interrupts frei
 while(1)                // schlafende Schleife durch Interrupt unterbrochen
 {
 } // Ende while
} // Ende main
