

// k4p17.c  ATmega8 Test  der SPI Schnittstelle  
// Systemtakt 1 MHz : 4 = 259 kHz Schiebetakt
// Port B: SPI Anschlsse 74HCT165 und 74HC595
// Port D: Eingabe nach Empfnger-Slave (LED)
// Port C: Ausgabe des Sender-Slave (Schalter)
// Konfiguration: interner Oszillator 1 MHz, extenes Reset-Signal
#include <avr/io.h>                    // Deklarationen
unsigned char empf(void)            // liefert Daten des Sender-Slave
{
 sbi(PORTB,PB1);                     // SH/LD = 1: schieben
 SPDR = 0xff;                        // Start der bertragung
 while( !(SPSR & (1 << SPIF)));    // warte bis Bit 1: fertig
 cbi(PORTB,PB1);                     // SH/LD = 0: laden
 return SPDR;                       // Empfangsdaten abholen 
}
void send(unsigned char wert)      // sendet wert seriell nach Slave
{
 cbi(PORTB,PB2);                      // RCK bernahme Low
 SPDR = wert;                         // Daten nach Sender und starten
 while( !(SPSR & (1 << SPIF)));     // warte bis Bit 1: fertig
 wert = SPDR;                         // SPIF wieder 0 (Pseudolesen)
 sbi(PORTB,PB2);                      // RCK bernahme High: steigende Flanke
}
void main(void)                      // Hauptfunktion
{
 DDRC = 0xff;                         // Port C ist Ausgang
 DDRB = (1 << DDB5) | (1 << DDB3) | (1 << DDB2) | (1 << DDB1); // Ausgnge SPI
 cbi(PORTB,PB1);                      // Sender-Slave SH/LD = 0: laden
 sbi(PORTB,PB2);                      // Empfnger-Slave bernahme RCK=1
 SPCR = (1 << SPE) | ( 1 << MSTR);   // SPI ein MSB erst Master Systemtakt / 4 
 while(1)                             // Arbeitsschleife
 {
  PORTC = empf();                     // Kontrollausgabe nach Port C
  send(~PIND);                        // Eingabe von Port D senden
 } // Ende while
} // Ende main