

// k3p9.c   ATmega8   Signal abtasten, speichern und auswerten
// Port B: Ausgabe Anzahl der Prellungen dezimal
// Port D: Eingabe fallende Flanke am Port D beginnt Speicherung 
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>        // Deklarationen
#include "dual2bcd.c"      // dual -> BCD
#define TAKT 1000000UL     // Controllertakt 1 MHz
#define N 1000             // Anzahl der Aufzeichnungen
void main(void)           // Hauptfunktion
{
 unsigned char feld[N], x;    // Feld vereinbart
 unsigned int i;              // Zhlvariable
 DDRB = 0xff;                  // Port B ist Ausgang
 while(1)                     // Arbeitsschleife
 {
  x = 0; PORTB = 0;                       // Zhler und Ausgabe lschen                  
  while ( PIND == 0xff);                  // warte auf fallende Flanke
  for (i=0; i < N; i++) feld[i] = PIND;  // Port N mal speichern 13 Takte
  for (i=0; i < N-1; i++)  if (feld[i] != feld[i+1]) x++;  // Flanken zhlen
  PORTB = dual2bcd(x);                   // Prellungen dezimal ausgeben
  while ( !(PIND == 0xff));             // warte auf steigende Flanke
 } // Ende while
} // Ende main
