

// k3p8.c  ATmega8  Zhler mit Tastenkontrolle
// Port B: Ausgabe dezimal 00 bis 99
// Port D: PD7: Zhler+1  PD6: Zhler-1  PD5: Zhler lschen
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>               // Deklarationen
#define TAKT 1000000UL            // Symbol Controllertakt 1 MHz
#include "wartex10ms.c"           // wartet ca. n * 10 ms 
#include "dual2bcd.c"             // Umwandlung dual nach dezimal
void main(void)                   // Hauptfunktion
{
 unsigned char zaehler=0;         // Zhler Bytevariable
 DDRB = 0xff;                     // Port B ist Ausgang
 PORTB = zaehler;                 // Anfangswert Null ausgeben
 while(1)                         // Arbeitsschleife
 {
 
 // wenn entprellte Taste PD7 fallende Flanke dann Zhler + 1 
  if ( !(PIND & (1 << PD7)) )          // wenn Taste Low
  {
   if (zaehler < 99) zaehler++;         // maximal 99
   PORTB = dual2bcd(zaehler);
   while ( !(PIND & (1 << PD7)) );     // warte solange Low
  } // Ende if
 
 // wenn Taste PD6 Low dann Zhler - 1 mit auto-repeat 
  if ( !(PIND & (1 << PD6)) )          // wenn Taste Low
  {
   if (zaehler > 0) zaehler--;         // minimal 0
   PORTB = dual2bcd(zaehler);
   wartex10ms(25);                     // 250 ms warten
   if( (PIND & (1 << PD6)) ) wartex10ms(1); // bei High 10 ms entprellen
  } // Ende if
  
  // wenn Taste PD5 fallende Flanke dann Zhler lschen
  if ( !(PIND & (1 << PD5)) )          // wenn Taste Low
  {
   zaehler = 0;                        // Zhler lschen
   PORTB = dual2bcd(zaehler);
   wartex10ms(1);                      // 10 ms entprellen
   while ( !(PIND & (1 << PD5)) );     // warte solange Low
   wartex10ms(1);                      // 10 ms entprellen
  } // Ende if
 } // Ende while
} // Ende main
