

// k3p20.c  ATmega8 Test der stdio-Funktionen 
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
// Minimalversion nur fr Zeichen, Strings und ganze Zahlen getestet
#include <avr/io.h>        // Deklarationen
#include <stdio.h>         // Standard Ein/Ausgabe-Funktionen
#define TAKT 1000000UL     // Controllertakt 1 MHz
#define BAUD 9600UL        // Baudrate 9600 Bd
void inituart(void)      // USART bzw. UART initialisieren
{
 unsigned char x;        // Hilfsvariable
 UBRRL = (TAKT / (8 * BAUD)) - 1;
 UBRRH = 0;
 UCSRA |= (1 << U2X);     // doppelte Baudrate Faktor 8
 UCSRB |= (1 << TXEN) | (1 << RXEN);
 UCSRC |= (1 << URSEL) | (1 << UCSZ1) | (1 << UCSZ0);  
 x = UDR;                 // Empfnger leeren
}
int putch (char x)       // warten und Zeichen senden
{
 while ( !(UCSRA & (1 << UDRE))); // warte solange Sender besetzt
 UDR = x;                           // Zeichen nach Sender
 return 0;                         // Marke kein Fehler 
}
int getch(void)   // warten und Zeichen abholen
{
 while ( !(UCSRA & (1 << RXC))); // warte solange Empfnger besetzt
 return UDR;                      // Zeichen abholen und rckliefern
}
int getche(void)  // warten und Zeichen mit Echo abholen
{
 unsigned char x;
 x = getch();                     // Zeichen abholen
 putch(x);                        // im Echo zurcksenden
 return x;                       // Zeichen zurckliefern
}
void main(void)                 // Hauptfunktion
{
 char meldung [] = "\n\rStringeingabe mit lf (Alt-1-0) abschliessen"; 
 char z, text[81];            // Zeichen und String
 int x, y, marke;             // Zahlenvariable und Fehlermarke 
 inituart();                  // USART-Schnittstelle initialisieren
 fdevopen(putch, getche, 0);  // Zeichenfunktionen fr stdout und stdin 
 puts("Bitte ein Zeichen eingeben");
 putchar('>');                // Prompt-Zeichen > ausgeben
 z = getchar();               // Zeichen-Eingabe mit Echo
 puts(meldung);               // Stringvariable ausgeben   
 gets(text);                  // Test-String lesen 
 puts(text);                  // Test-String ausgeben
 while(1)                    // Testschleife fr ganze Zahlen
 {
  printf("\n\rZwei ganze Zahlen ->");                     // Meldung
  marke = scanf("%i %i", &x, &y);                         // Eingabe zwei Zahlen 
  if (marke == 2)  printf("\n %i + %i = %i", x, y, x+y); // Zahlen-Ausgabe  
   else { clearerr(stdin); getchar(); puts(" Eingabefehler"); }  // Fehler
 } // Ende while
} // Ende main
