

// k3p16.c  ATmega8  Verkettete Liste aufbauen und ausgeben
// Port B: Ausgabe der Listenwerte dann Endemarke 0x55
// Port D: Eingabe Taste PD7 bis Wert Null
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>                   // Deklarationen
#include <stdlib.h>                   // fr malloc und NULL    
#define TAKT 1000000UL                // Controllertakt 8 MHz
#include "wartex10ms.c"               // wartet n * 10 ms
void main(void)                      // Hauptfunktion
{
 struct styp {                        // Typdeklaration
               unsigned char x,daten;   // Datenteil
			   struct styp *nach;     // Zeiger auf Nachfolger
              };                     
 struct styp *kopfz, *altz, *laufz;  // Zeigervariablen 
 unsigned char wert, i = 0;         // Eingabewert und Zhler
 DDRB = 0xff;                         // Port B ist Ausgang
 kopfz = NULL;                        // Kopfzeiger
 laufz = NULL;                        // laufender Zeiger
 altz = NULL;                         // Zeiger auf Vorgnger
 while(1)                            // Eingeben und speichern
 {
  while ( PIND & (1 << PD7) );      // warte solange PD7 High
  wert = PIND;                        // Eingabewert
  if (wert == 0) break;              // Abbruch der Eingabe fr Null
  altz = laufz;                       // Zeiger auf Vorgnger
  laufz = malloc(1*sizeof(*laufz));  // neuen Speicher anfordern
  laufz->daten = wert;                // Daten ablegen
  laufz->nach = NULL;                  // Endemarke  
  if (kopfz == NULL) kopfz = laufz;      // Zeiger nach Kopf
  if (kopfz != NULL) altz->nach = laufz; // Zeiger nach Vorgnger 
  PORTB = ++i;                        // laufender Kontrollzhler
  while ( !(PIND & (1 << PD7)) );    // warte solange PD7 Low
 } // Ende while Liste aufbauen
 while ( !(PIND & (1 << PD7)) );    // warte solange PD7 Low
 laufz = kopfz;                        // Zeiger auf 1.Element
 while(laufz != NULL)                 // Liste ausgeben
 {
  PORTB = laufz->daten;                // Daten ausgeben
  laufz = laufz->nach;                 // Zeiger auf Nachfolger
  wartex10ms(100);                      // ca. 1 sek warten
 } // Ende while ausgeben
 PORTB = 0x55;                         // Marke fr Ende des Programms
 } // Ende main                        // Neustart mit RESET
