// c:\cprog\k3p25\hedoku.c ATmega16 Brutaler Hexa-Doku Knacker 
// STK500  Programmers Notepad 2  GNU-Compiler avr-gcc 3.4.1
#include <avr/io.h>        // Deklarationen
#define TAKT 1000000UL     // Controllertakt 1 MHz
#define BAUD 9600ul        // Baudrate 
#define SLENG 81           // Lnge des Eingabepuffers
#define a 16                // Anzahl der Zeilen und Spalten
// globale Vereinbarungen Vorgabefeld enthlt 134 Nullen
unsigned char f[a][a] = {
                           {14,99, 3, 8,99, 9, 5,99,99, 7,99, 2, 4,11,13,15} , \
						   {99, 6,99,99,99,11,99,13,99, 3,99, 9, 7,99,14,99} , \
						   {99, 5, 7,99,99,99,14,99,99,11,10,99, 6,12, 9,99} , \
						   {99,99,11,99, 0,99, 7, 6,99,14,99,99,99, 3,99, 5} , \
						   {99,99,99,99, 7,99,99,99,13,99,99,99,99,10, 0,99} , \
						   {99,99,99,99,99, 2,99, 3,99,99, 1,99,15,99,12,11} , \
						   {99,14, 6,11,99,99,15,99,99, 9,99, 0,99, 5, 2,99} , \
						   {10,99, 5,99, 1, 0,11,99,99,12,99,99,99, 4,99,99} , \
						   {99, 1,99,99, 9,15,13, 2,99, 0,99, 6,99, 8, 4,99} , \
						   {99, 8,13, 3,99, 7, 1,99,99,10,99, 4,99, 0,99,99} , \
						   { 5,99,99, 4,99,99, 6, 0,12, 8, 7,13,99,99,15, 1} , \
						   { 6,15,99,99,99, 8,99,99,99, 2,14,99,10,99, 5, 9} , \
						   {99,99,99,99,99,13,12,99, 2,99,99,99, 0,99,99,99} , \
						   {15, 0, 2,99,99,99,99,10, 8,99,11,99,99,14,99, 4} , \
						   { 8, 3,99, 5, 2,99,99,99, 7, 6, 9,10,99,15, 1,13} , \
						   {99,10,99,99,99, 6,99, 7,99,99,99,99, 2,99, 8, 3} };
							
unsigned char zeile[SLENG];  // Eingabepuffer fr sgets

// Grundfunktionen zur Eingabe und Ausgabe von Zeichen und Texten
void inituart(void)       // USART bzw. UART initialisieren
{
 unsigned char x;        // Hilfsvariable
 #ifdef UBRRL              // USART-Schnittstelle 
  UBRRL = (TAKT / (8 * BAUD)) - 1;
  UCSRA |= (1 << U2X);
  UCSRB |= (1 << TXEN) | (1 << RXEN);
  UCSRC |= (1 << URSEL) | (1 << UCSZ1) | (1 << UCSZ0); 
 #else                    // UART-Schnittstelle
  UBRR = (TAKT / (16 * BAUD)) - 1;
  UCR |= (1 << TXEN) | (1 << RXEN);
 #endif 
 x = UDR;                // Empfnger leeren
}

void putch (unsigned char x)  // warten und Zeichen senden
{
 #ifdef UCSRA
  loop_until_bit_is_set(UCSRA, UDRE); // warte bis Sender frei
 #else
  loop_until_bit_is_set(USR, UDRE);   // warte bis Sender frei
 #endif
 UDR = x;                             // Zeichen nach Sender    
}

unsigned char getch(void)   // warten und Zeichen abholen
{
 #ifdef UCSRA
 loop_until_bit_is_set(UCSRA, RXC);    // warte bis Zeichen da
#else 
 loop_until_bit_is_set(USR, RXC);      // warte bis Zeichen da
 #endif
 return UDR;                           // Zeichen abholen
}

unsigned char getche(void)  // warten und Zeichen mit Echo abholen
{
 unsigned char x;
 x = getch();                          // Zeichen abholen
 putch(x);                             // im Echo zurcksenden
 return x;                             // Zeichen zurckliefern
}

// Stringfunktionen fr nullterminierte Strings
void sputs(unsigned char *zeiger)     // SRAM_String ausgeben
{
 while(*zeiger != 0) putch(*zeiger++);
}

unsigned char sgets(unsigned char *zeiger) // String lesen mit Korrektur
{
 unsigned anz = 0;                         // Zeichenzhler
 while(1)
 {
  *zeiger = getch();                     // Zeichen lesen ohne Echo
  if(*zeiger >= 0x20 && anz < SLENG)    // kein Steuerzeichen
  {
   putch(*zeiger); anz++; zeiger++;     // Echo Zhler Zeiger erhhen
  } // Ende if
  else 
  {
   if(*zeiger != '\b' || anz >= SLENG)  // Ende der Eingaben
   {
    *zeiger = 0; return anz;            // Rckgabe Anzahl der Zeichen    
   } // Ende if
   else 
   if(*zeiger == '\b' && anz != 0)     // Korrektur mit Rcktaste 
   {
    zeiger--; putch('\b'); putch(' '); putch('\b'); anz--;
   }  // Ende if
  } // Ende else 
 } // Ende while
}  // Ende Funktion

// Funktion zur Ausgabe von Testwerten
void testaus(unsigned char z, unsigned char i, unsigned char j, unsigned char k)
{
 sputs("\n\rRegel "); putch(z); putch(0x20);
 if (i <= 9) putch(i+0x30); else putch(i+0x37); putch(0x20);
 if (j <= 9) putch(j+0x30); else putch(j+0x37); putch(0x20);
 if (k <= 9) putch(k+0x30); else putch(k+0x37); putch(0x20);
 putch('>'); getch();
}

// Regelfunktionen liefern Anzahl der Ziffern x
unsigned char rzeile(unsigned char j, unsigned char x)
{
 unsigned char i, n = 0;
 for (i = 0; i < a; i++) if (f[i][j] == x) n++; 
 return n; 
}
unsigned char rspalte(unsigned char i, unsigned char x)
{
 unsigned char j, n = 0;
 for (j = 0; j < a; j++) if (f[i][j] == x) n++; 
 return n; 
}
unsigned char rfeld(unsigned char ix, unsigned char jx, unsigned char x)
{
 unsigned char ia=0, ja=0, i, j, n = 0; 
 if (ix <= 3) ia = 0;
 if (ix >= 4 && ix <= 7) ia = 4;
 if (ix >= 8 && ix <= 11) ia = 8;
 if (ix >= 12) ia = 12;
 if (jx <= 3) ja = 0;
 if (jx >= 4 && jx <= 7) ja = 4;
 if (jx >= 8 && jx <= 11) ja = 8;
 if (jx >= 12) ja = 12;
 for (i = 0; i < 4; i++)
 {
  for (j = 0; j < 4; j++) if (f[i+ia][j+ja] == x) n++;
 } // Ende for
 return n;
} // Ende Funktion

unsigned char rmehr(unsigned char ix, unsigned char jx, unsigned char x)
{
 signed char i1=0, i2=0, i3=0, j1=0, j2=0, j3=0;
 if ( (ix % 4) == 0) { i1=+1; i2=+2; i3=+3; }
 if ( (ix % 4) == 1) { i1=-1; i2=+1; i3=+2; }
 if ( (ix % 4) == 2) { i1=-2; i2=-1; i3=+1; }
 if ( (ix % 4) == 3) { i1=-3; i2=-2; i3=-1; }
 if ( (jx % 4) == 0) { j1=+1; j2=+2; j3=+3; }
 if ( (jx % 4) == 1) { j1=-1; j2=+1; j3=+2; }
 if ( (jx % 4) == 2) { j1=-2; j2=-1; j3=+1; }
 if ( (jx % 4) == 3) { j1=-3; j2=-2; j3=-1; }
 // Drei Nachbarzeilen untersuchen
 if ( rzeile(jx+j1,x) == 1 && rzeile(jx+j2,x) == 1 &&  rzeile(jx+j3,x) == 1)
     {
      if ((rspalte(ix+i1,x) == 1 || f[ix+i1][jx] != 99) &&  \
	      (rspalte(ix+i2,x) == 1 || f[ix+i2][jx] != 99) &&  \
	      (rspalte(ix+i3,x) == 1 || f[ix+i3][jx] != 99) ) return 1;
	 } // Ende if
 // Drei Nachbarspalten untersuchen
 if ( rspalte(ix+i1,x) == 1 && rspalte(ix+i2,x) == 1 &&  rspalte(ix+i3,x) == 1)
     {
	  // testaus('s',ix,jx,x); //  TEST
	  // testaus('1',ix,j1,x); //  TEST
	  // testaus('2',ix,j2,x); //  TEST
	  // testaus('3',ix,j3,x); //  TEST
     if ((rzeile(jx+j1,x) == 1 || f[ix][jx+j1] != 99) &&  \
	     (rzeile(jx+j2,x) == 1 || f[ix][jx+j2] != 99) &&  \
	     (rzeile(jx+j3,x) == 1 || f[ix][jx+j3] != 99) ) return 1; 
     } // Ende if 
    return 0;
}
unsigned char ein(void)  // Eingabe liefert die Anzahl der leeren Felder
{
 unsigned char i, j, nz, k = 0;
 sputs("\n\r\ngenau 16 Ziffern 0..9 oder a..f oder lz\n\r   vvvvvvvvvvvvvvvv");
 for (j = 0; j < a; j++)
 {
  nz = 0;
  do
  {
   sputs("\n\r ->"); nz = sgets(zeile); 
   if (nz != a) sputs(" Fehler! Zeile nochmal eingeben");
  } while (nz < a); 
  for (i = 0; i < a; i++)
  {
   f[i][j] = 99; 
   if (zeile[i] >= '0' && zeile[i] <= '9') f[i][j] = zeile[i] - 0x30; 
   if (zeile[i] >= 'a' && zeile[i] <= 'f') f[i][j] = zeile[i] - 0x37; 
   if (zeile[i] == ' ') { (f[i][j] == 99); k++; }
  } // Ende for i 
 } // Ende for j
 return k;             // Anzahl der leeren Felder 
} // Ende ein 

void aus(void)        // Ausgabe des Spielfeldes                   
{
 unsigned char i, j, z;
 sputs("\n\r\nAusgabe des Spielfeldes");
 for(j = 0; j < a; j++) 
 {
  putch(10); putch(13);
  for (i = 0; i < a; i++) 
  {
   putch(' '); 
   z = f[i][j];   
   if (z == 99) putch ('.');
    else { if (z <= 9) putch(z+'0'); else putch(z+'0'+7); }
  } // Ende for i
 } // Ende for j
 sputs("\n\rWeiter mit cr ->"); getch();
} // Ende aus

// *****************************************************************************
main(void)                 // Hauptfunktion
{
 unsigned char i, j, k, geht, nleer, gef, n=0, m[a], l;  
 inituart();               // V.24 Schnittstelle initialisieren 
 sputs("\n\rSu-Doku Zahlenknacker Vorgabefeld ? v -> "); 
 if (getche() == 'v') nleer = 134; else nleer = ein();    
 aus(); // Kontrollausgabe  
 while (1)                       //  Endlosschleife
 {        
 while(nleer != 0)              // Arbeitsschleife
 {
  n = 0;                         // Sicherheitszhler
  for (j = 0; j < a; j++)       // fr alle Zeilen
  {
   for (i = 0; i < a; i++)      // fr alle Spalten
   {
    if (f[i][j] == 99)           // nur wenn Feld leer
	{
     geht = 0; gef = 0; l = 0;   // Zhler fr mgliche Besetzungen
     for (k = 0; k < a; k++)    // fr alle Zahlen von 0 .. f
     {
	  if (rzeile(j,k)==0 && rspalte(i,k)==0 && rfeld(i, j, k)==0)
       { gef = k; m[geht++] = k; l++; }	
     } // Ende for k Zahlen
	 if (l == 1) { nleer--; f[i][j] = gef; n++; }  // nur wenn eindeutig  
	 if (l >= 2)                                     // mehrere Zahlen mglich
	 {
	  for(l=0; l < geht; l++) 
	  {
	   k = m[l]; 
	   if (rmehr(i, j, k) == 1) { nleer--; f[i][j] = k; n++; break; };   
	  } // Ende for l 
	 } // Ende if l >=2
    } // Ende if Feld leer 99
   } // Ende for i Spalten
  } // Ende for j Zeilen
  aus(); // Zwischenausgabe zur Kontrolle
  if (n == 0) break;            // Abbruch verhindert Endlosschleife 
 } // Ende while leer
 if (n == 0 && nleer != 0) sputs("\n\r\nSuch Dir ein anderes Programm!");  
       else  sputs("\n\r\n******* Sudoku geloest *********"); 
 nleer = ein(); aus();           // neue Eingabe und Kontrollausgabe           
} // Ende while 1	   
} // Ende main
