

; UART.h Konsolfunktionen fr UART direkt einbauen
init:   ldi   r16,takt/(16*baud) - 1 ; 
        out   UBRR,r16  ; nach Baudratenregister
        sbi   UCR,RXEN  ; Empfnger ein
        sbi   UCR,TXEN  ; Sender ein
        in    r16,UDR   ; Empfangsregister leeren
        ret             ;
;
getch:  sbis  USR,RXC   ; Empfangsbit ?
        rjmp  getch     ; 0: kein Zeichen da
        in    r16,UDR   ; R16 <= Empfnger
        ret             ;
; 
putch:  sbis  USR,UDRE  ; Sendedatenregisterbit ?
        rjmp  putch     ; 0: besetzt
        out   UDR,r16   ; Sender <- R16
        ret             ;
;
getche: rcall getch     ; R16 <- Zeichen
        rcall putch     ; senden im Echo
        ret             ; 

