

; test2.asm ATMega16 Dualzhler als Taktteiler
; PORTA: -
; PORTB: Ausgabe Systemtakt : 10 an PB0 = 800 kHz
; PORTC: Ausgabe Systemtakt : 10 an PC0 = 800 kHz
; PORTD: -
        .INCLUDE  "m16def.inc"  ; Deklarationen fr Mega16
        .EQU    takt = 8000000  ; Systemtakt 8 MHz 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
        clr     akku            ; Zhler lschen
; 5 Takte Low / 5 Takte High gibt Systemtakt:10 an PB0 und PC0
loop:   out     PORTB,akku      ; 1 Takt:  Zhler auf Port B ausgeben
        out     PORTC,akku      ; 1 Takt:  Zhler auf Port C ausgeben
        inc     akku            ; 1 Takt:  Zhler um 1 erhhen
        rjmp    loop            ; 2 Takte: Schleife
        .EXIT                   ; Ende des Quelltextes

