

; test10.asm Test Umcodierung mit Tabellen
; Port B: Ausgabe ASCII oder Fehleranzeige
; Port D: Eingabe ASCII
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    TAKT = 8000000  ; Systemtakt 8 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapelzeiger
        out     SPL,akku        ; anlegen
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku        ;
        ser     akku            ; akku <- $ff
        out     DDRB,akku       ; Port B ist Ausgang
loop:   in      akku,PIND       ; R16 <- Eingabe Ziffer im ASCII-Code
        rcall   asciitbin       ; Umwandlung R16 <- binr
        brcs    error           ; C = 1: keine Ziffer 0-9 A-F a-f
        rcall   bintascii       ; C = 0: Rckwandlung R16 <- ASCII
        out     PORTB,akku      ; Kontrollausgabe Port B 
        rjmp    loop            ; 
error:  ldi     akku,$FF        ; Fehlermarke Anzeige dunkel
        out     PORTB,akku      ;
        rjmp    loop            ; 
; Unterprogramme werden hier eingefgt
        .INCLUDE "asciitbin.asm"; R16 Umcodierung ASCII -> binr
        .INCLUDE "bintascii.asm"; R16 Umcodierung binr -> ASCII
       .EXIT                    ; Ende des Quelltextes
