

; p30.asm Bild 4-54 : AT90S2313 UART Polling 3.6864 MHz 9600 baud 8 Bits
; Port B: Ausgabe des empfangenen Zeichens 
; Port D: PD0=RXD PD1=TXD  PD2..PD6 frei
        .INCLUDE "2313def.inc"  ; mit Portdeklarationen
        .EQU     baud = 9600    ; Symbol fr Baudrate
        .EQU     takt = 3686400 ; Symbol fr Controllertakt
        .DEF     akku = r16     ; Arbeitsregister
        .CSEG                   ; Programmsegment im Flash
        rjmp     start          ; Reset-Einsprung
        .ORG     $10            ; Interrupteinsprnge bergehen
start:  ldi      akku,LOW(RAMEND) ; Stapel anlegen
        out      SPL,akku       ;
        ldi      akku,$ff       ; Richtung Port B
        out      DDRB,akku      ; ist Ausgang
        rcall    init           ; UART initialisieren
        ldi      akku,'>'       ; Prompt
        rcall    putch          ; ausgeben
; Hauptprogrammschleife
haupt:  rcall    getche         ; Empfnger lesen nach Akku mit Echo
        out      PORTB,akku     ; auf Port B ausgeben
        rjmp     haupt          ;
       .INCLUDE  "UART.h"       ; UART-Konsolfunktionen init,putch,getche
       .EXIT                    ; 
