

; k5p2.asm ATmega8 Testprogramm fr One-Task-Bootlader
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden von PIND
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden Dualzhler 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
; 
; Testschleife Abbruch mit Taste PD7
loop:   sbis    PIND,PIND7      ; berspringe wenn PD7 High
        rjmp    ende            ; Abbruch fr PD7 Low
        in      akku,PIND       ; Eingabe Anschlsse Pin D   
        out     PORTB,akku      ; Ausgabe Anschlsse Port B  
        in      akku,PORTC      ; Eingabe alter Zhler       
        inc     akku            ; Zhler erhhen             
        out     PORTC,akku      ; neuen Zhler ausgeben      
        rjmp    loop            ; Sprung zum Schleifenanfang 
ende:   rjmp    LARGEBOOTSTART  ; nach Bootlader 
        .EXIT                   ; Ende des Quelltextes


