

; k4p21.asm  ATmega8  Test des Analogkomparators
; Port B: -
; Port C: -
; Port D: PD7: AIN1  PD6: AIN0  PD5: Ausgabe ACO
; Konfiguration: interner Oszillator; externes Reset-Signal
        .INCLUDE "m8def.inc"     ; Deklarationen
        .DEF     akku = r16      ; Arbeitsregister
        .CSEG                    ; Programmsegment
         rjmp   start            ;
        .ORG    $13              ; keine Interrupts
start:  ldi     akku,LOW(RAMEND) ; Stapel anlegen
        out     SPL,akku         ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku         ;
        sbi     DDRD,DDD5        ; PD5 ist Ausgang
        cbi     ACSR,ACD         ; Komparator ein
loop:   in      akku,ACSR        ; Anzeige ACO laden
        out     PORTD,akku       ; und ausgeben PD5
        rjmp    loop             ; Schleife
        .EXIT                    ; Ende des Quelltextes

