

; k4p16.asm  ATmega8  USART Test synchron senden
; Port B: - 
; Port C: -
; Port D: PD1 -> TXD  COM1 9600 Bd  PD4 Schiebetakt
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"     ; Deklarationen fr Mega8
        .EQU    takt = 1000000    ; Systemtakt 1 MHz intern 
        .EQU    baud = 9600         ; Baudrate
        .DEF    akku = r16        ; Arbeitsregister
        .CSEG                     ; Programm-Flash
        rjmp    start             ; Reset-Einsprung
        .ORG    $13               ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND)  ; Stapel anlegen
        out     SPL,akku          ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku          ;        
        ldi     akku,LOW(takt/(2*baud) - 1) ; Baudrate Low
        out     UBRRL,akku        ; 
        ldi     akku,HIGH(takt/(2*baud) - 1) ; Baudrate High
        andi    akku,$7F          ; Maske 0111 1111 URSEL = 0
        out     UBRRH,akku        ;
        ldi     akku,(1 << URSEL) | (1 << UMSEL) | (1 << UCSZ1) | (1 << UCSZ0) ; 
        out     UCSRC,akku        ; UCSRC ein, synch., 1 Stopp, 8 Datenbits
        sbi     DDRD,PD4          ; Taktleitung als Ausgang
        sbi     UCSRB,TXEN        ; nur Sender ein
        ldi     akku,$55          ; Bitmuster 0101 0101
loop:   sbis    UCSRA,UDRE        ; berspringe wenn Sender frei
        rjmp    loop              ; warte solange Sender besetzt
        out     UDR,akku          ; Zeichen synchron senden
        rjmp    loop              ; Sendeschleife
       .EXIT                      ; Ende des Quelltextes
   
